/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PredictRequestMarshaller
implements Marshaller<Request<PredictRequest>, PredictRequest> {
    public Request<PredictRequest> marshall(PredictRequest predictRequest) {
        if (predictRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)predictRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.Predict";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (predictRequest.getMLModelId() != null) {
                jsonWriter.name("MLModelId").value(predictRequest.getMLModelId());
            }
            if (predictRequest.getRecord() != null) {
                jsonWriter.name("Record");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> recordListValue : predictRequest.getRecord().entrySet()) {
                    if (recordListValue.getValue() == null) continue;
                    jsonWriter.name(recordListValue.getKey());
                    jsonWriter.value(recordListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (predictRequest.getPredictEndpoint() != null) {
                jsonWriter.name("PredictEndpoint").value(predictRequest.getPredictEndpoint());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

