/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Prediction
implements Serializable {
    private String predictedLabel;
    private Float predictedValue;
    private Map<String, Float> predictedScores = new HashMap<String, Float>();
    private Map<String, String> details = new HashMap<String, String>();

    public String getPredictedLabel() {
        return this.predictedLabel;
    }

    public void setPredictedLabel(String predictedLabel) {
        this.predictedLabel = predictedLabel;
    }

    public Prediction withPredictedLabel(String predictedLabel) {
        this.predictedLabel = predictedLabel;
        return this;
    }

    public Float getPredictedValue() {
        return this.predictedValue;
    }

    public void setPredictedValue(Float predictedValue) {
        this.predictedValue = predictedValue;
    }

    public Prediction withPredictedValue(Float predictedValue) {
        this.predictedValue = predictedValue;
        return this;
    }

    public Map<String, Float> getPredictedScores() {
        return this.predictedScores;
    }

    public void setPredictedScores(Map<String, Float> predictedScores) {
        this.predictedScores = predictedScores;
    }

    public Prediction withPredictedScores(Map<String, Float> predictedScores) {
        this.predictedScores = predictedScores;
        return this;
    }

    public Prediction addpredictedScoresEntry(String key, Float value) {
        if (null == this.predictedScores) {
            this.predictedScores = new HashMap<String, Float>();
        }
        if (this.predictedScores.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.predictedScores.put(key, value);
        return this;
    }

    public Prediction clearpredictedScoresEntries() {
        this.predictedScores = null;
        return this;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Prediction withDetails(Map<String, String> details) {
        this.details = details;
        return this;
    }

    public Prediction adddetailsEntry(String key, String value) {
        if (null == this.details) {
            this.details = new HashMap<String, String>();
        }
        if (this.details.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.details.put(key, value);
        return this;
    }

    public Prediction cleardetailsEntries() {
        this.details = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictedLabel() != null) {
            sb.append("predictedLabel: " + this.getPredictedLabel() + ",");
        }
        if (this.getPredictedValue() != null) {
            sb.append("predictedValue: " + this.getPredictedValue() + ",");
        }
        if (this.getPredictedScores() != null) {
            sb.append("predictedScores: " + this.getPredictedScores() + ",");
        }
        if (this.getDetails() != null) {
            sb.append("details: " + this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictedLabel() == null ? 0 : this.getPredictedLabel().hashCode());
        hashCode = 31 * hashCode + (this.getPredictedValue() == null ? 0 : this.getPredictedValue().hashCode());
        hashCode = 31 * hashCode + (this.getPredictedScores() == null ? 0 : this.getPredictedScores().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)obj;
        if (other.getPredictedLabel() == null ^ this.getPredictedLabel() == null) {
            return false;
        }
        if (other.getPredictedLabel() != null && !other.getPredictedLabel().equals(this.getPredictedLabel())) {
            return false;
        }
        if (other.getPredictedValue() == null ^ this.getPredictedValue() == null) {
            return false;
        }
        if (other.getPredictedValue() != null && !other.getPredictedValue().equals(this.getPredictedValue())) {
            return false;
        }
        if (other.getPredictedScores() == null ^ this.getPredictedScores() == null) {
            return false;
        }
        if (other.getPredictedScores() != null && !other.getPredictedScores().equals(this.getPredictedScores())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }
}

