/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PredictRequestMarshaller
implements Marshaller<Request<PredictRequest>, PredictRequest> {
    public Request<PredictRequest> marshall(PredictRequest predictRequest) {
        if (predictRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PredictRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)predictRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.Predict";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (predictRequest.getMLModelId() != null) {
                String mLModelId = predictRequest.getMLModelId();
                jsonWriter.name("MLModelId");
                jsonWriter.value(mLModelId);
            }
            if (predictRequest.getRecord() != null) {
                Map<String, String> record = predictRequest.getRecord();
                jsonWriter.name("Record");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> recordEntry : record.entrySet()) {
                    String recordValue = recordEntry.getValue();
                    if (recordValue == null) continue;
                    jsonWriter.name(recordEntry.getKey());
                    jsonWriter.value(recordValue);
                }
                jsonWriter.endObject();
            }
            if (predictRequest.getPredictEndpoint() != null) {
                String predictEndpoint = predictRequest.getPredictEndpoint();
                jsonWriter.name("PredictEndpoint");
                jsonWriter.value(predictEndpoint);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

