/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.services.machinelearning.model.Prediction;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Map;

class PredictionJsonMarshaller {
    private static PredictionJsonMarshaller instance;

    PredictionJsonMarshaller() {
    }

    public void marshall(Prediction prediction, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (prediction.getPredictedLabel() != null) {
            String predictedLabel = prediction.getPredictedLabel();
            jsonWriter.name("predictedLabel");
            jsonWriter.value(predictedLabel);
        }
        if (prediction.getPredictedValue() != null) {
            Float predictedValue = prediction.getPredictedValue();
            jsonWriter.name("predictedValue");
            jsonWriter.value((Number)predictedValue);
        }
        if (prediction.getPredictedScores() != null) {
            Map<String, Float> predictedScores = prediction.getPredictedScores();
            jsonWriter.name("predictedScores");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : predictedScores.entrySet()) {
                Float predictedScoresValue = (Float)entry.getValue();
                if (predictedScoresValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value((Number)predictedScoresValue);
            }
            jsonWriter.endObject();
        }
        if (prediction.getDetails() != null) {
            Map<String, String> details = prediction.getDetails();
            jsonWriter.name("details");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : details.entrySet()) {
                String detailsValue = (String)entry.getValue();
                if (detailsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value(detailsValue);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    public static PredictionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PredictionJsonMarshaller();
        }
        return instance;
    }
}

