/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.InternalSessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.Session;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.SessionStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.ActiveSessionState;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.InactiveSessionState;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.PausedSessionState;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.SessionClientState;

@Deprecated
public class DefaultSessionClient
implements InternalSessionClient {
    public static final String SESSION_START_EVENT_TYPE = "_session.start";
    public static final String SESSION_STOP_EVENT_TYPE = "_session.stop";
    public static final String SESSION_PAUSE_EVENT_TYPE = "_session.pause";
    public static final String SESSION_RESUME_EVENT_TYPE = "_session.resume";
    protected static final long DEFAULT_RESUME_DELAY = 5000L;
    protected static final long DEFAULT_RESTART_DELAY = 30000L;
    protected static final String RESUME_DELAY_CONFIG_KEY = "sessionResumeDelay";
    protected static final String RESTART_DELAY_CONFIG_KEY = "sessionRestartDelay";
    protected final InternalEventClient eventClient;
    protected final AnalyticsContext context;
    protected Session session;
    protected SessionClientState state;
    protected final SessionStore sessionStore;
    private final SessionClientState INACTIVE_STATE = new InactiveSessionState(this);
    private final SessionClientState ACTIVE_STATE = new ActiveSessionState(this);
    private final SessionClientState PAUSED_STATE = new PausedSessionState(this);
    private final long resumeDelay;
    private final long restartDelay;

    @Override
    public synchronized void startSession() {
        this.state.start();
    }

    @Override
    public synchronized void stopSession() {
        this.state.stop();
    }

    @Override
    public synchronized void pauseSession() {
        this.state.pause();
    }

    @Override
    public synchronized void resumeSession() {
        this.state.resume();
    }

    public String toString() {
        return "[DefaultSessionClient]\n- session: " + (this.session == null ? "<null>" : this.session.getSessionID()) + (this.session != null && this.session.isPaused() ? ": paused" : "");
    }

    public DefaultSessionClient(AnalyticsContext context, InternalEventClient eventClient, SessionStore sessionStore) {
        Preconditions.checkNotNull(context, "A valid InsightsContext must be provided!");
        Preconditions.checkNotNull(eventClient, "A valid EventClient must be provided!");
        Preconditions.checkNotNull(sessionStore, "A valid SessionStore must be provided!");
        this.sessionStore = sessionStore;
        this.eventClient = eventClient;
        this.context = context;
        this.session = this.sessionStore.getSession();
        if (this.session != null) {
            eventClient.setSessionId(this.session.getSessionID());
            eventClient.setSessionStartTime(this.session.getStartTime());
        }
        this.state = this.session == null ? this.INACTIVE_STATE : this.PAUSED_STATE;
        this.restartDelay = context.getConfiguration().optLong(RESTART_DELAY_CONFIG_KEY, 30000L);
        this.resumeDelay = context.getConfiguration().optLong(RESUME_DELAY_CONFIG_KEY, 5000L);
    }

    protected Session getSession() {
        return this.session;
    }

    public long getRestartDelay() {
        return this.restartDelay;
    }

    public long getResumeDelay() {
        return this.resumeDelay;
    }

    protected SessionState getSessionState() {
        if (this.session != null) {
            return this.session.isPaused() ? SessionState.PAUSED : SessionState.ACTIVE;
        }
        return SessionState.INACTIVE;
    }

    protected synchronized void changeState(SessionState s) {
        switch (s) {
            case INACTIVE: {
                this.state = this.INACTIVE_STATE;
                break;
            }
            case ACTIVE: {
                this.state = this.ACTIVE_STATE;
                break;
            }
            case PAUSED: {
                this.state = this.PAUSED_STATE;
                break;
            }
        }
    }

    protected static enum SessionState {
        INACTIVE,
        ACTIVE,
        PAUSED;

    }
}

