/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.configuration;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.configuration.Configuration;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Preferences;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class PreferencesConfiguration
implements Configuration {
    private static final String TAG = "PreferencesConfiguration";
    private static final String CONFIG_KEY = "configuration";
    private final AnalyticsContext context;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public static PreferencesConfiguration newInstance(AnalyticsContext context) {
        return new PreferencesConfiguration(context);
    }

    PreferencesConfiguration(AnalyticsContext context) {
        String configurationJsonString;
        Preconditions.checkNotNull(context);
        this.context = context;
        JSONObject configJson = null;
        Preferences preferences = this.getContext().getSystem().getPreferences();
        if (preferences != null && (configurationJsonString = preferences.getString(CONFIG_KEY, null)) != null) {
            try {
                configJson = new JSONObject(configurationJsonString);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"could not create Json object of Config", (Throwable)e);
            }
        }
        this.updateMappings(configJson);
    }

    @Override
    public Long getLong(String propertyName) {
        Long value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Long.decode(valueString);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Could not get Long for propertyName: %s", propertyName), (Throwable)ex);
            }
        }
        return value;
    }

    @Override
    public String getString(String propertyName) {
        String value = this.properties.get(propertyName);
        return value;
    }

    @Override
    public Integer getInt(String propertyName) {
        Integer value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Integer.decode(valueString);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Could not get Integer for propertyName: %s", propertyName), (Throwable)ex);
            }
        }
        return value;
    }

    @Override
    public Double getDouble(String propertyName) {
        Double value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Could not get Double for propertyName: %s", propertyName), (Throwable)ex);
            }
        }
        return value;
    }

    @Override
    public Boolean getBoolean(String propertyName) {
        Boolean value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Boolean.parseBoolean(valueString);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Could not get Boolean for propertyName: %s", propertyName), (Throwable)ex);
            }
        }
        return value;
    }

    @Override
    public Short getShort(String propertyName) {
        Short value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                if (this.properties.containsKey(propertyName)) {
                    value = Short.decode(valueString);
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)String.format("Could not get Short for propertyName: %s", propertyName), (Throwable)ex);
            }
        }
        return value;
    }

    @Override
    public Long optLong(String propertyName, Long optValue) {
        Long value = this.getLong(propertyName);
        return value != null ? value : optValue;
    }

    @Override
    public String optString(String propertyName, String optValue) {
        String value = this.getString(propertyName);
        return value != null ? value : optValue;
    }

    @Override
    public Integer optInt(String propertyName, Integer optValue) {
        Integer value = this.getInt(propertyName);
        return value != null ? value : optValue;
    }

    @Override
    public Short optShort(String propertyName, Short optValue) {
        Short value = this.getShort(propertyName);
        return value != null ? value : optValue;
    }

    @Override
    public Double optDouble(String propertyName, Double optValue) {
        Double value = this.getDouble(propertyName);
        return value != null ? value : optValue;
    }

    @Override
    public Boolean optBoolean(String propertyName, Boolean optValue) {
        Boolean value = this.getBoolean(propertyName);
        return value != null ? value : optValue;
    }

    private void updateMappings(JSONObject configJson) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (configJson != null) {
            Iterator keys = configJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String value = configJson.getString(key);
                    newProperties.put(key, value);
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)"could not update property mappings", (Throwable)e);
                }
            }
        }
        this.properties.putAll(newProperties);
    }

    private AnalyticsContext getContext() {
        return this.context;
    }
}

