/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery;

import android.util.Log;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.MobileAnalyticsManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.DeliveryClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.ERSRequestBuilder;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStoreException;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.FileEventStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.policy.DefaultDeliveryPolicyFactory;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.policy.DeliveryPolicy;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.adapter.EventAdapter;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.adapter.JSONEventAdapter;
import com.amazonaws.services.mobileanalytics.model.PutEventsRequest;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class DefaultDeliveryClient
implements DeliveryClient {
    public static final String EVENTS_DIRECTORY = "events";
    private static final String USER_AGENT = MobileAnalyticsManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String TAG = "DefaultDeliveryClient";
    private static final int MAX_EVENT_OPERATIONS = 1000;
    private static final int MAX_SUBMIT_OPERATIONS = 100;
    private static final int CLIPPED_EVENT_LENGTH = 5;
    static final String KEY_MAX_SUBMISSION_SIZE = "maxSubmissionSize";
    static final long DEFAULT_MAX_SUBMISSION_SIZE = 102400L;
    static final String KEY_MAX_SUBMISSIONS_ALLOWED = "maxSubmissionAllowed";
    static final int DEFAULT_MAX_SUBMISSIONS_ALLOWED = 3;
    static final Set<Integer> RETRY_REQUEST_CODES = new HashSet<Integer>();
    private final DefaultDeliveryPolicyFactory policyFactory;
    private final ExecutorService eventsRunnableQueue;
    private final ExecutorService submissionRunnableQueue;
    private final AnalyticsContext context;
    private final ERSRequestBuilder requestBuilder;
    private final EventStore eventStore;
    private final EventAdapter<JSONObject> eventAdapter;
    private final AtomicLong avgWriteEventTimeMillis = new AtomicLong(25L);
    private final AtomicLong eventsProcessed = new AtomicLong(0L);
    private long lastAttemptTime = 0L;

    public static DefaultDeliveryClient newInstance(AnalyticsContext context, boolean allowWANDelivery) {
        ThreadPoolExecutor eventsExService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.DiscardPolicy());
        ThreadPoolExecutor submissionsExService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardPolicy());
        ERSRequestBuilder requestBuilder = new ERSRequestBuilder();
        DefaultDeliveryPolicyFactory policyFactory = new DefaultDeliveryPolicyFactory(context, allowWANDelivery);
        return new DefaultDeliveryClient(context, policyFactory, eventsExService, submissionsExService, requestBuilder, FileEventStore.newInstance(context), new JSONEventAdapter());
    }

    DefaultDeliveryClient(AnalyticsContext context, DefaultDeliveryPolicyFactory policyFactory, ExecutorService eventsRunnableQueue, ExecutorService submissionRunnableQueue, ERSRequestBuilder requestBuilder, EventStore eventStore, EventAdapter<JSONObject> eventAdapter) {
        this.policyFactory = policyFactory;
        this.eventsRunnableQueue = eventsRunnableQueue;
        this.submissionRunnableQueue = submissionRunnableQueue;
        this.context = context;
        this.requestBuilder = requestBuilder;
        this.eventStore = eventStore;
        this.eventAdapter = eventAdapter;
    }

    @Override
    public void notify(InternalEvent event) {
        this.enqueueEventForDelivery(event);
    }

    @Override
    public void enqueueEventForDelivery(final InternalEvent event) {
        final long startEnqueueTimeMillis = System.currentTimeMillis();
        final long origEventsProcessed = this.eventsProcessed.get();
        this.eventsRunnableQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    boolean eventStored = DefaultDeliveryClient.this.eventStore.put(((JSONObject)DefaultDeliveryClient.this.eventAdapter.translateFromEvent(event)).toString());
                    if (eventStored) {
                        Log.i((String)DefaultDeliveryClient.TAG, (String)String.format("Event: '%s' recorded to local filestore", StringUtil.clipString(event.getEventType(), 5, true)));
                        Log.d((String)DefaultDeliveryClient.TAG, (String)String.format("Time of enqueueEventForDelivery: %d", System.currentTimeMillis() - start));
                    } else {
                        Log.w((String)DefaultDeliveryClient.TAG, (String)String.format("Event: '%s' failed to record to local filestore", StringUtil.clipString(event.getEventType(), 5, true)));
                    }
                }
                catch (EventStoreException e) {
                    Log.w((String)DefaultDeliveryClient.TAG, (String)String.format("Event: '%s' failed to record to local filestore", StringUtil.clipString(event.getEventType(), 5, true)));
                }
                finally {
                    DefaultDeliveryClient.this.calculateAndSetAverageWriteEventTime(origEventsProcessed, startEnqueueTimeMillis);
                }
            }
        });
    }

    private void calculateAndSetAverageWriteEventTime(long origEventsProcessed, long enqueueTimeMillis) {
        long currentEventsProcessed = this.eventsProcessed.addAndGet(1L);
        long eventsWrittenDelta = currentEventsProcessed - origEventsProcessed;
        long durationInMillis = System.currentTimeMillis() - enqueueTimeMillis;
        double decimalAvg = (double)durationInMillis / (double)eventsWrittenDelta;
        long avg = (long)Math.ceil(decimalAvg);
        this.avgWriteEventTimeMillis.set(avg);
    }

    private long getSubmissionLatchWaitTime() {
        return (long)((double)(this.avgWriteEventTimeMillis.get() * 1000L) * 1.5);
    }

    @Override
    public void attemptDelivery() {
        ArrayList<DeliveryPolicy> policies = new ArrayList<DeliveryPolicy>();
        DeliveryPolicy forceSubmissionPolicy = this.policyFactory.newForceSubmissionTimePolicy();
        DeliveryPolicy connectivityPolicy = this.policyFactory.newConnectivityPolicy();
        if (connectivityPolicy != null) {
            policies.add(connectivityPolicy);
        }
        if (forceSubmissionPolicy != null) {
            policies.add(forceSubmissionPolicy);
        }
        this.attemptDelivery(policies);
    }

    boolean shouldAttemptDelivery(long lastSubmissionAttemptTime, long minimumSubmissionInterval) {
        return System.currentTimeMillis() - lastSubmissionAttemptTime > minimumSubmissionInterval || System.currentTimeMillis() - lastSubmissionAttemptTime < 0L;
    }

    JSONArray getNextBatchToSubmit(EventStore.EventIterator iter, long maxRequestSize) throws JSONException {
        if (iter == null) {
            throw new IllegalArgumentException("Iterator cannot be null");
        }
        long currentRequestSize = 0L;
        long eventLength = iter.peek() != null ? (long)iter.peek().length() : 0L;
        JSONArray eventArray = new JSONArray();
        while (currentRequestSize + eventLength <= maxRequestSize && iter.hasNext()) {
            currentRequestSize += eventLength;
            eventLength = iter.peek() != null ? (long)iter.peek().length() : 0L;
            eventArray.put((Object)new JSONObject((String)iter.next()));
        }
        return eventArray;
    }

    public void attemptDelivery(final List<DeliveryPolicy> policies) {
        if (this.shouldAttemptDelivery(this.lastAttemptTime, this.policyFactory.forceSubmissionInterval)) {
            this.lastAttemptTime = System.currentTimeMillis();
            final CountDownLatch submitWaitLatch = new CountDownLatch(1);
            this.eventsRunnableQueue.execute(new Runnable(){

                @Override
                public void run() {
                    submitWaitLatch.countDown();
                }
            });
            this.submissionRunnableQueue.execute(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    for (DeliveryPolicy policy : policies) {
                        if (policy.isAllowed()) continue;
                        Log.d((String)DefaultDeliveryClient.TAG, (String)("Policy " + policy.getClass() + " is not allowed"));
                        return;
                    }
                    try {
                        submitWaitLatch.await(DefaultDeliveryClient.this.getSubmissionLatchWaitTime(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean successful = true;
                    long maxRequestSize = DefaultDeliveryClient.this.context.getConfiguration().optLong(DefaultDeliveryClient.KEY_MAX_SUBMISSION_SIZE, 102400L);
                    JSONArray toSend = new JSONArray();
                    EventStore.EventIterator iter = DefaultDeliveryClient.this.eventStore.iterator();
                    int submissions = 0;
                    int maxAllowedSubmissions = DefaultDeliveryClient.this.context.getConfiguration().optInt(DefaultDeliveryClient.KEY_MAX_SUBMISSIONS_ALLOWED, 3);
                    while (iter.hasNext() && submissions < maxAllowedSubmissions) {
                        try {
                            toSend = DefaultDeliveryClient.this.getNextBatchToSubmit(iter, maxRequestSize);
                            successful = DefaultDeliveryClient.this.submitEvents(toSend, policies);
                            if (!successful) break;
                            ++submissions;
                            iter.removeReadEvents();
                        }
                        catch (JSONException e) {
                            Log.e((String)DefaultDeliveryClient.TAG, (String)"Could not convert stored event into json", (Throwable)e);
                        }
                        catch (Exception e) {
                            Log.e((String)DefaultDeliveryClient.TAG, (String)"An internal error occured, events could not be submitted", (Throwable)e);
                        }
                    }
                    Log.v((String)DefaultDeliveryClient.TAG, (String)String.format("Time of attemptDelivery: %d", System.currentTimeMillis() - start));
                }
            });
        }
    }

    boolean submitEvents(JSONArray eventArray, List<DeliveryPolicy> policies) {
        boolean submitted = false;
        PutEventsRequest request = this.requestBuilder.createRecordEventsRequest(eventArray, this.context.getNetworkType());
        request.withClientContextEncoding("base64");
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        try {
            this.context.getERSClient().putEvents(request);
            submitted = true;
            Log.i((String)TAG, (String)String.format("Successful submission of %d events", eventArray.length()));
            for (DeliveryPolicy policy : policies) {
                policy.handleDeliveryAttempt(submitted);
            }
            return submitted;
        }
        catch (AmazonServiceException e) {
            Log.e((String)TAG, (String)"AmazonServiceException occured during send of put event ", (Throwable)e);
            String errorCode = e.getErrorCode();
            if (errorCode.equalsIgnoreCase("ValidationException") || errorCode.equalsIgnoreCase("SerializationException") || errorCode.equalsIgnoreCase("BadRequestException")) {
                submitted = true;
                Log.e((String)TAG, (String)String.format("Failed to submit events to EventService: statusCode: " + e.getStatusCode() + " errorCode: ", errorCode));
                Log.e((String)TAG, (String)String.format("Failed submission of %d events, events will be removed", eventArray.length()), (Throwable)e);
                for (DeliveryPolicy policy : policies) {
                    policy.handleDeliveryAttempt(submitted);
                }
                return submitted;
            }
            Log.w((String)TAG, (String)("Unable to successfully deliver events to server. Events will be saved, error likely recoverable.  Response status code " + e.getStatusCode() + " , response error code " + e.getErrorCode() + e.getMessage()));
            Log.w((String)TAG, (String)("Recieved an error response: " + e.getMessage()));
        }
        catch (Exception e2) {
            Log.w((String)TAG, (String)("Unable to successfully deliver events to server. Events will be saved, error likely recoverable." + e2.getMessage()));
        }
        for (DeliveryPolicy policy : policies) {
            policy.handleDeliveryAttempt(submitted);
        }
        return submitted;
    }

    static {
        RETRY_REQUEST_CODES.add(401);
        RETRY_REQUEST_CODES.add(404);
        RETRY_REQUEST_CODES.add(407);
        RETRY_REQUEST_CODES.add(408);
    }
}

