/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class ClientContext {
    private static final String TAG = "ClientContext";
    private String appPackageName = "";
    private String appTitle = "";
    private String appVersionName = "";
    private String appVersionCode = "";
    private String uniqueId = "";
    private static final String CLIENT_OBJECT_KEY = "client";
    private String model = "";
    private String make = "";
    private String platform = "ANDROID";
    private String platformVersion = "";
    private String locale = "en-US";
    private String networkType = "";
    private String carrier = "";
    private static final String ENVIRONMENT_OBJECT_KEY = "env";
    private Map<String, String> custom = new HashMap<String, String>();
    private static final String CUSTOM_OBJECT_KEY = "custom";
    private String appId = "";
    public static final String APP_ID_KEY = "app_id";
    private static final String SERVICES_OBJECT_KEY = "services";
    private static final String MOBILE_ANALYTICS_KEY = "mobile_analytics";

    private ClientContext() {
    }

    public JSONObject toJSONObject() {
        HashMap<String, String> clientMap = new HashMap<String, String>();
        clientMap.put("app_package_name", this.appPackageName);
        clientMap.put("app_title", this.appTitle);
        clientMap.put("app_version_name", this.appVersionName);
        clientMap.put("app_version_code", this.appVersionCode);
        clientMap.put("client_id", this.uniqueId);
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("model", this.model);
        envMap.put("make", this.make);
        envMap.put("platform", this.platform);
        envMap.put("platform_version", this.platformVersion);
        envMap.put("locale", this.locale);
        envMap.put("carrier", this.carrier);
        envMap.put("networkType", this.networkType);
        HashMap<String, JSONObject> servicesMap = new HashMap<String, JSONObject>();
        HashMap<String, String> analyticsServiceMap = new HashMap<String, String>();
        analyticsServiceMap.put(APP_ID_KEY, this.appId);
        JSONObject mobileAnalytics = new JSONObject(analyticsServiceMap);
        servicesMap.put(MOBILE_ANALYTICS_KEY, mobileAnalytics);
        JSONObject clientObj = new JSONObject(clientMap);
        JSONObject envObj = new JSONObject(envMap);
        JSONObject customObj = new JSONObject(this.custom);
        JSONObject servicesObj = new JSONObject(servicesMap);
        JSONObject clientContextJSON = new JSONObject();
        try {
            clientContextJSON.put(CLIENT_OBJECT_KEY, (Object)clientObj);
            clientContextJSON.put(ENVIRONMENT_OBJECT_KEY, (Object)envObj);
            clientContextJSON.put(CUSTOM_OBJECT_KEY, (Object)customObj);
            clientContextJSON.put(SERVICES_OBJECT_KEY, (Object)servicesObj);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error creating clientContextJSON", (Throwable)e);
            return clientContextJSON;
        }
        return clientContextJSON;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public void setAppTitle(String appTitle) {
        this.appTitle = appTitle;
    }

    public String getAppVersionName() {
        return this.appVersionName;
    }

    public void setAppVersionName(String appVersionName) {
        this.appVersionName = appVersionName;
    }

    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    public void setAppVersionCode(String appVersionCode) {
        this.appVersionCode = appVersionCode;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getMake() {
        return this.make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, String> custom) {
        this.custom = custom;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static class ClientContextBuilder {
        private String appPackageName = "";
        private String appTitle = "";
        private String appVersionName = "";
        private String appVersionCode = "";
        private String uniqueId = "";
        private String model = "";
        private String make = "";
        private String platform = "ANDROID";
        private String platformVersion = "";
        private String locale = "";
        private String networkType = "";
        private String carrier = "";
        private Map<String, String> custom = new HashMap<String, String>();
        private String appId = "";

        public ClientContext build() {
            ClientContext result = new ClientContext();
            result.setAppPackageName(this.appPackageName);
            result.setAppTitle(this.appTitle);
            result.setAppVersionName(this.appVersionName);
            result.setAppVersionCode(this.appVersionCode);
            result.setUniqueId(this.uniqueId);
            result.setMake(this.make);
            result.setModel(this.model);
            result.setPlatform(this.platform);
            result.setPlatformVersion(this.platformVersion);
            result.setLocale(this.locale);
            result.setNetworkType(this.networkType);
            result.setCarrier(this.carrier);
            result.setCustom(this.custom);
            result.setAppId(this.appId);
            return result;
        }

        public ClientContextBuilder withCarrier(String carrier) {
            this.carrier = Preconditions.checkNotNull(carrier);
            return this;
        }

        public ClientContextBuilder withNetworkType(String networkType) {
            this.networkType = Preconditions.checkNotNull(networkType);
            return this;
        }

        public ClientContextBuilder withAppPackageName(String appPackageName) {
            this.appPackageName = Preconditions.checkNotNull(appPackageName);
            return this;
        }

        public ClientContextBuilder withAppTitle(String appTitle) {
            this.appTitle = Preconditions.checkNotNull(appTitle);
            return this;
        }

        public ClientContextBuilder withAppVersionName(String appVersionName) {
            this.appVersionName = Preconditions.checkNotNull(appVersionName);
            return this;
        }

        public ClientContextBuilder withAppVersionCode(String appVersionCode) {
            this.appVersionCode = Preconditions.checkNotNull(appVersionCode);
            return this;
        }

        public ClientContextBuilder withUniqueId(String uniqueId) {
            this.uniqueId = Preconditions.checkNotNull(uniqueId);
            return this;
        }

        public ClientContextBuilder withModel(String model) {
            this.model = Preconditions.checkNotNull(model);
            return this;
        }

        public ClientContextBuilder withMake(String make) {
            this.make = Preconditions.checkNotNull(make);
            return this;
        }

        public ClientContextBuilder withPlatformVersion(String platformVersion) {
            this.platformVersion = Preconditions.checkNotNull(platformVersion);
            return this;
        }

        public ClientContextBuilder withCustomFields(Map<String, String> customFields) {
            this.custom = Preconditions.checkNotNull(customFields);
            return this;
        }

        public ClientContextBuilder withLocale(String locale) {
            this.locale = Preconditions.checkNotNull(locale);
            return this;
        }

        public ClientContextBuilder withAppId(String appId) {
            this.appId = appId;
            return this;
        }
    }
}

