/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.http;

import android.util.Log;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Connectivity;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.DateUtil;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEventClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

@Deprecated
public class RequestTimingHandler
extends RequestHandler2 {
    private static final String TAG = "RequestTimingHandler";
    public static final String REQUESTTIME_HEADER = "x-amzn-RequestTime";
    public static final String REQUESTATTEMPTS_HEADER = "x-amzn-RequestAttempts";
    public static final String SERVERINFO_HEADER = "x-amzn-ServerInfo";
    private static final String TIMEZONE_FORMAT = "Z";
    private DateFormat df = DateUtil.createLocaleIndependentDateFormatter("Z");
    private final InternalEventClient eventClient;
    private final Connectivity connectivity;
    private long startTime;
    private int contentLength;

    public RequestTimingHandler(Connectivity connectivity, InternalEventClient eventClient) {
        this.eventClient = eventClient;
        this.connectivity = connectivity;
    }

    private synchronized String getTimeZone() {
        return this.df.format(new Date());
    }

    public void afterError(Request<?> request, Response<?> response, Exception exception) {
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        try {
            if (response == null) {
                return;
            }
            Map headers = response.getHttpResponse().getHeaders();
            String responseTimeStr = (String)headers.get(REQUESTTIME_HEADER);
            long responseTime = this.startTime - System.currentTimeMillis();
            if (responseTimeStr != null && responseTimeStr.trim().length() > 0) {
                try {
                    responseTime = Long.parseLong(responseTimeStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            double responseDouble = -1.0;
            try {
                responseDouble = Double.valueOf(Long.toString(responseTime));
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)TAG, (String)"Couldn't convert response time to double format", (Throwable)numberFormatException);
            }
            String requestAttemptsStr = (String)headers.get(REQUESTATTEMPTS_HEADER);
            double requestAttempts = 0.0;
            if (requestAttemptsStr != null && requestAttemptsStr.trim().length() > 0) {
                try {
                    requestAttempts = Double.parseDouble(requestAttemptsStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String serverInfo = (String)headers.get(SERVERINFO_HEADER);
            if (!StringUtil.isNullOrEmpty(responseTimeStr)) {
                if (this.eventClient == null) {
                    return;
                }
                AnalyticsEvent recordEvent = this.eventClient.createEvent("_httpRequestTiming").withAttribute("url", request.getEndpoint().toURL().toString()).withAttribute("responseCode", Integer.toString(response.getHttpResponse().getStatusCode())).withAttribute("timeZone", this.getTimeZone()).withMetric("attempts", requestAttempts).withMetric("totalTime", responseDouble).withMetric("requestSize", Double.valueOf(this.contentLength));
                String connectionType = "UNKNOWN";
                if (this.connectivity != null) {
                    if (this.connectivity.hasWifi()) {
                        connectionType = "WIFI";
                    } else if (this.connectivity.hasWAN()) {
                        connectionType = "WAN";
                    }
                }
                recordEvent.withAttribute("network", connectionType);
                if (serverInfo != null) {
                    recordEvent.withAttribute("serverInfo", serverInfo);
                }
                this.eventClient.recordEvent(recordEvent);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Unable to record _RequestTime event", (Throwable)e);
        }
    }

    public void beforeRequest(Request<?> request) {
        this.startTime = System.currentTimeMillis();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = request.getContent();
        int currentByte = 0;
        try {
            while ((currentByte = is.read()) != -1) {
                baos.write(currentByte);
            }
            this.contentLength = baos.size();
            request.setContent((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Cannot read content of request");
            throw new RuntimeException(e);
        }
    }
}

