/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobileanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.mobileanalytics.model.Event;
import com.amazonaws.services.mobileanalytics.model.PutEventsRequest;
import com.amazonaws.services.mobileanalytics.model.transform.EventJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPOutputStream;

@Deprecated
public class PutEventsRequestMarshaller
implements Marshaller<Request<PutEventsRequest>, PutEventsRequest> {
    public Request<PutEventsRequest> marshall(PutEventsRequest putEventsRequest) {
        if (putEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutEventsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEventsRequest, "AmazonMobileAnalytics");
        request.setHttpMethod(HttpMethodName.POST);
        if (putEventsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)putEventsRequest.getClientContext()));
        }
        if (putEventsRequest.getClientContextEncoding() != null) {
            request.addHeader("x-amz-Client-Context-Encoding", StringUtils.fromString((String)putEventsRequest.getClientContextEncoding()));
        }
        String uriResourcePath = "/2014-06-05/events";
        request.setResourcePath(uriResourcePath);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, 8192);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StringUtils.UTF8);
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            if (putEventsRequest.getEvents() != null) {
                List<Event> events = putEventsRequest.getEvents();
                jsonWriter.name("events");
                jsonWriter.beginArray();
                for (Event eventsItem : events) {
                    if (eventsItem == null) continue;
                    EventJsonMarshaller.getInstance().marshall(eventsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            gos.finish();
            ((Writer)writer).close();
            byte[] content = baos.toByteArray();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

