/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics;

import android.content.Context;
import android.util.Log;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsCallback;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsConfig;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.InitializationException;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.SessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.DefaultAnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.http.RequestTimingHandler;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.DefaultEventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.FileSessionStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.InternalSessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.DefaultSessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.validate.EncodingValidator;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.validate.FileManagerValidator;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.validate.PermissionValidator;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.mobileanalytics.AmazonMobileAnalyticsClient;
import com.amazonaws.util.VersionInfoUtils;
import java.util.HashMap;

public class MobileAnalyticsManager {
    private static final String SDK_VERSION = VersionInfoUtils.getVersion();
    private static final String SDK_NAME = "AmazonMobileAnalyticsSDK";
    private static final SDKInfo sdkInfo = new SDKInfo("AmazonMobileAnalyticsSDK", SDK_VERSION);
    private static final String TAG = "MobileAnalyticsManager";
    private static final PermissionValidator internetPermissionValidator = new PermissionValidator("android.permission.INTERNET");
    private static final PermissionValidator accessNetworkStatePermissionValidator = new PermissionValidator("android.permission.ACCESS_NETWORK_STATE");
    private static final HashMap<String, MobileAnalyticsManager> instanceMap = new HashMap();
    private static final EncodingValidator encodingValidator = new EncodingValidator("UTF-8");
    private static final FileManagerValidator fileManagerValidator = new FileManagerValidator();
    private final AnalyticsContext context;
    private final InternalEventClient eventClient;
    private final InternalSessionClient sessionClient;

    MobileAnalyticsManager(Context appContext, String appId, Regions region, AWSCredentialsProvider credentialsProvider, AnalyticsConfig options, AnalyticsCallback<MobileAnalyticsManager> initCompletionCallback) throws InitializationException {
        try {
            Preconditions.checkNotNull(credentialsProvider, "The ersClient provided must not be null");
            Preconditions.checkNotNull(appContext, "The application context provided must not be null");
            Preconditions.checkNotNull(options, "The options provided must not be null");
            Preconditions.checkNotNull(appId, "The app ID specified must not be null");
            AmazonMobileAnalyticsClient ersClient = new AmazonMobileAnalyticsClient(credentialsProvider, options.getClientConfiguration());
            internetPermissionValidator.validate(appContext);
            accessNetworkStatePermissionValidator.validate(appContext);
            encodingValidator.validate();
            this.context = new DefaultAnalyticsContext(ersClient, appContext, region, appId, sdkInfo, options.getAllowWANDelivery());
            fileManagerValidator.validate(this.context);
            this.eventClient = new DefaultEventClient(this.context, options.getAllowEventCollection());
            this.sessionClient = new DefaultSessionClient(this.context, this.eventClient, new FileSessionStore(this.context));
            this.context.getERSClient().addRequestHandler(new RequestTimingHandler(this.context.getSystem().getConnectivity(), this.eventClient));
            if (initCompletionCallback != null) {
                initCompletionCallback.onComplete(this);
            }
            this.sessionClient.startSession();
            Log.d((String)TAG, (String)String.format("Amazon Mobile Analytics SDK(%s) initialization successfully completed", SDK_VERSION));
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"Cannot initialize Amazon Mobile Analytics SDK", (Throwable)e);
            throw new InitializationException(e.getLocalizedMessage());
        }
    }

    MobileAnalyticsManager(Context appContext, String appId, Regions region, AWSCredentialsProvider credentialsProvider, AnalyticsConfig options, AnalyticsCallback<MobileAnalyticsManager> initCompletionCallback, AnalyticsContext analyticsContext, InternalEventClient eventClient, InternalSessionClient sessionClient, AmazonMobileAnalyticsClient ersClient) throws InitializationException {
        try {
            Preconditions.checkNotNull(credentialsProvider, "The ersClient provided must not be null");
            Preconditions.checkNotNull(appContext, "The application context provided must not be null");
            Preconditions.checkNotNull(options, "The options provided must not be null");
            Preconditions.checkNotNull(appId, "The app ID specified must not be null");
            internetPermissionValidator.validate(appContext);
            accessNetworkStatePermissionValidator.validate(appContext);
            encodingValidator.validate();
            this.context = analyticsContext;
            this.sessionClient = sessionClient;
            this.eventClient = eventClient;
            fileManagerValidator.validate(this.context);
            this.context.getERSClient().addRequestHandler(new RequestTimingHandler(this.context.getSystem().getConnectivity(), eventClient));
            if (initCompletionCallback != null) {
                initCompletionCallback.onComplete(this);
            }
            sessionClient.startSession();
            Log.d((String)TAG, (String)String.format("Amazon Mobile Analytics SDK(%s) initialization successfully completed", SDK_VERSION));
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"Cannot initialize Amazon Mobile Analytics SDK", (Throwable)e);
            throw new InitializationException(e.getLocalizedMessage());
        }
    }

    public EventClient getEventClient() {
        return this.eventClient;
    }

    public SessionClient getSessionClient() {
        return this.sessionClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobileAnalyticsManager getInstance(String appId) {
        HashMap<String, MobileAnalyticsManager> hashMap = instanceMap;
        synchronized (hashMap) {
            return instanceMap.get(appId);
        }
    }

    public static MobileAnalyticsManager getOrCreateInstance(Context context, String appId, Regions region, AWSCredentialsProvider credentialsProvider) throws InitializationException {
        return MobileAnalyticsManager.getOrCreateInstance(context, appId, region, credentialsProvider, null, null);
    }

    public static MobileAnalyticsManager getOrCreateInstance(Context context, String appId, Regions region, AWSCredentialsProvider credentialsProvider, AnalyticsConfig options) throws InitializationException {
        return MobileAnalyticsManager.getOrCreateInstance(context, appId, region, credentialsProvider, options, null);
    }

    public static MobileAnalyticsManager getOrCreateInstance(Context context, String appId, Regions region, AWSCredentialsProvider credentialsProvider, AnalyticsCallback<MobileAnalyticsManager> initCompletionCallback) throws InitializationException {
        return MobileAnalyticsManager.getOrCreateInstance(context, appId, region, credentialsProvider, null, initCompletionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobileAnalyticsManager getOrCreateInstance(Context context, String appId, Regions region, AWSCredentialsProvider credentialsProvider, AnalyticsConfig options, AnalyticsCallback<MobileAnalyticsManager> initCompletionCallback) throws InitializationException {
        HashMap<String, MobileAnalyticsManager> hashMap = instanceMap;
        synchronized (hashMap) {
            if (!instanceMap.containsKey(appId)) {
                if (options == null) {
                    options = new AnalyticsConfig();
                }
                instanceMap.put(appId, new MobileAnalyticsManager(context, appId, region, credentialsProvider, options, initCompletionCallback));
            }
            return instanceMap.get(appId);
        }
    }
}

