/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.Id;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.UniqueIdService;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Preferences;
import java.util.UUID;

public class SharedPrefsUniqueIdService
implements UniqueIdService {
    private static final String TAG = "SharedPrefsUniqueIdService";
    protected static final String PREFS_NAME = SharedPrefsUniqueIdService.class.getName();
    protected static final String UNIQUE_ID_KEY = "UniqueId";
    private String appId = null;
    private Context applicationContext = null;

    public SharedPrefsUniqueIdService(String appId, Context applicationContext) {
        this.appId = appId;
        this.applicationContext = applicationContext;
    }

    @Override
    public Id getUniqueId(AnalyticsContext context) {
        if (context == null || context.getSystem() == null || context.getSystem().getPreferences() == null) {
            Log.d((String)TAG, (String)"Unable to generate unique id, context has not been fully initialized");
            return Id.getEmptyId();
        }
        Id uniqueId = this.getIdFromPreferences(context.getSystem().getPreferences());
        if (uniqueId == Id.getEmptyId()) {
            uniqueId = new Id(UUID.randomUUID().toString());
            this.storeUniqueId(context.getSystem().getPreferences(), uniqueId);
        }
        return uniqueId;
    }

    private Id getIdFromPreferences(Preferences preferences) {
        Id uniqueId = Id.getEmptyId();
        if (this.getLegacyId() != Id.getEmptyId()) {
            return this.getLegacyId();
        }
        String uniqueIdString = preferences.getString(UNIQUE_ID_KEY, null);
        if (uniqueIdString != null) {
            uniqueId = new Id(uniqueIdString);
        }
        return uniqueId;
    }

    private Id getLegacyId() {
        if (this.appId == null || this.applicationContext == null) {
            return Id.getEmptyId();
        }
        SharedPreferences legacyPreferences = this.applicationContext.getSharedPreferences(this.appId, 0);
        String legacyId = legacyPreferences.getString(UNIQUE_ID_KEY, null);
        if (legacyId != null) {
            return new Id(legacyId);
        }
        return Id.getEmptyId();
    }

    private void storeUniqueId(Preferences preferences, Id uniqueId) {
        try {
            preferences.putString(UNIQUE_ID_KEY, uniqueId.getValue());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"There was an exception when trying to store the unique id into the Preferences", (Throwable)ex);
        }
    }
}

