/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultFileManager
implements FileManager {
    private final File directory;

    public DefaultFileManager(File rootDirectory) {
        this.directory = rootDirectory;
    }

    @Override
    public File createDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    @Override
    public File getDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return dir;
    }

    @Override
    public Set<File> listFilesInDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return this.listFilesInDirectory(dir);
    }

    @Override
    public Set<File> listFilesInDirectory(File directory) {
        HashSet<File> filesSet = new HashSet<File>();
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                filesSet.add(file);
            }
        }
        return Collections.unmodifiableSet(filesSet);
    }

    @Override
    public File createFile(String filepath) throws IOException {
        File file = new File(this.directory, filepath);
        return this.createFile(file);
    }

    @Override
    public File createFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return null;
        }
        return file;
    }

    @Override
    public boolean deleteFile(String filepath) {
        File file = new File(this.directory, filepath);
        return this.deleteFile(file);
    }

    @Override
    public boolean deleteFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    @Override
    public InputStream newInputStream(String filepath) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newInputStream(file);
    }

    @Override
    public InputStream newInputStream(File file) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        return stream;
    }

    @Override
    public OutputStream newOutputStream(String filepath, boolean append) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newOutputStream(file, append);
    }

    @Override
    public OutputStream newOutputStream(File file, boolean append) throws FileNotFoundException {
        FileOutputStream stream = new FileOutputStream(file, append);
        return stream;
    }
}

