/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONSerializable;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder
implements JSONSerializable {
    private JSONObject json = new JSONObject();

    public JSONBuilder(Object component) {
        if (null != component) {
            this.withAttribute("class", component.getClass().getName());
            this.withAttribute("hashCode", Integer.toHexString(component.hashCode()));
        }
    }

    public JSONBuilder withAttribute(String key, Object value) {
        Object jsonValue = value instanceof JSONSerializable ? ((JSONSerializable)value).toJSONObject() : value;
        try {
            this.json.putOpt(key, jsonValue);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return this;
    }

    @Override
    public JSONObject toJSONObject() {
        return this.json;
    }

    public String toString() {
        try {
            if (this.json != null) {
                return this.json.toString(4);
            }
            return "";
        }
        catch (JSONException e) {
            return this.json.toString();
        }
    }
}

