/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStoreException;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.Session;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.SessionStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.SessionStoreException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileSessionStore
implements SessionStore {
    private static final String TAG = "FileSessionStore";
    protected static final String SESSION_DIRECTORY = "sessions";
    protected static final String SESSION_FILE_NAME = "sessionFile";
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final long MAX_STORAGE_SIZE = 22560L;
    private final AnalyticsContext context;
    private File sessionFile;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readSessionLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeSessionLock = this.lock.writeLock();
    private BufferedReader reader = null;

    public FileSessionStore(AnalyticsContext context) {
        this.context = context;
        FileManager fileManager = this.context.getSystem().getFileManager();
        File sessionDir = fileManager.createDirectory(SESSION_DIRECTORY);
        try {
            this.sessionFile = fileManager.createFile(new File(sessionDir, SESSION_FILE_NAME));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"An error occurred while attempting to create/open the session file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSession(Session session) throws SessionStoreException {
        String serializedSession = session.toJSONObject().toString();
        Writer writer = null;
        this.writeSessionLock.lock();
        try {
            try {
                writer = this.tryInitializeWriter();
                if (writer != null) {
                    long maxStorageSize = this.context.getConfiguration().optLong(KEY_MAX_STORAGE_SIZE, 22560L);
                    if (this.sessionFile.length() + (long)serializedSession.length() <= maxStorageSize) {
                        writer.write(serializedSession);
                        writer.flush();
                    } else {
                        Log.e((String)TAG, (String)("The session file exceeded its allowed size of " + maxStorageSize + " bytes"));
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to persist the session", (Throwable)e);
            }
            finally {
                this.tryCloseWriter(writer);
            }
        }
        finally {
            this.writeSessionLock.unlock();
        }
    }

    private Writer tryInitializeWriter() throws SessionStoreException {
        OutputStreamWriter writer = null;
        try {
            OutputStream stream = this.context.getSystem().getFileManager().newOutputStream(this.sessionFile, false);
            writer = new OutputStreamWriter(stream);
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Session file not found to persist session to", (Throwable)e);
            throw new EventStoreException("Unable to open session file writer", e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Unexpected exception", (Throwable)e);
        }
        return writer;
    }

    private void tryCloseWriter(Writer writer) throws SessionStoreException {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to close writer for session file", (Throwable)e);
            }
        }
    }

    private boolean tryOpenReader() {
        if (this.reader != null) {
            return true;
        }
        InputStreamReader streamReader = null;
        try {
            streamReader = new InputStreamReader(this.context.getSystem().getFileManager().newInputStream(this.sessionFile));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Could not open the session file", (Throwable)e);
        }
        if (streamReader != null) {
            this.reader = new BufferedReader(streamReader);
            return true;
        }
        return false;
    }

    private void tryCloseReader() {
        if (this.reader != null) {
            this.readSessionLock.lock();
            try {
                try {
                    this.reader.close();
                }
                catch (IOException ioe) {
                    Log.e((String)TAG, (String)"Unable to close reader for session file", (Throwable)ioe);
                }
                finally {
                    this.reader = null;
                }
            }
            finally {
                this.readSessionLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        String serializedSession = null;
        this.readSessionLock.lock();
        try {
            try {
                this.tryOpenReader();
                if (this.reader != null) {
                    serializedSession = this.reader.readLine();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to read the session", (Throwable)e);
            }
            finally {
                this.tryCloseReader();
                FileManager fileManager = this.context.getSystem().getFileManager();
                try {
                    if (fileManager.deleteFile(this.sessionFile) || !this.sessionFile.exists()) {
                        this.sessionFile = fileManager.createFile(this.sessionFile);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to clear session file", (Throwable)e);
                }
            }
        }
        finally {
            this.readSessionLock.unlock();
        }
        return Session.getSessionFromSerializedSession(serializedSession);
    }
}

