/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Scanner;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Session
implements JSONSerializable {
    protected static final String SESSION_ID_DATE_FORMAT = "yyyyMMdd";
    protected static final String SESSION_ID_TIME_FORMAT = "HHmmssSSS";
    protected static final char SESSION_ID_DELIMITER = '-';
    protected static final char SESSION_ID_PAD_CHAR = '_';
    protected static final int SESSION_ID_APPKEY_LENGTH = 8;
    protected static final int SESSION_ID_UNIQID_LENGTH = 8;
    private static final String JSON_SESSION_ID_ATTR = "session_id";
    private static final String JSON_START_TIME_ATTR = "start_time";
    private static final String JSON_STOP_TIME_ATTR = "stop_time";
    private final DateFormat sessionIdTimeFormat;
    private final String sessionID;
    private final Long startTime;
    private Long stopTime = null;

    public static Session newInstance(AnalyticsContext context) {
        return new Session(context);
    }

    public static Session getSessionFromSerializedSession(String serializedSession) {
        Session s = null;
        if (StringUtil.isBlank(serializedSession)) {
            return s;
        }
        try {
            JSONObject json = new JSONObject(serializedSession);
            String sessionID = json.getString(JSON_SESSION_ID_ATTR);
            String startTime = json.getString(JSON_START_TIME_ATTR);
            String stopTime = json.getString(JSON_STOP_TIME_ATTR);
            s = new Session(sessionID, startTime, stopTime);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return s;
    }

    protected Session(AnalyticsContext context) {
        Preconditions.checkNotNull(context, "A valid AnalyticsContext must be provided!");
        this.sessionIdTimeFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS", Locale.US);
        this.sessionIdTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.startTime = System.currentTimeMillis();
        this.stopTime = null;
        this.sessionID = this.generateSessionID(context);
    }

    protected Session(String sessionID, String startTime, String stopTime) {
        this.sessionIdTimeFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS", Locale.US);
        this.sessionIdTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Scanner s = new Scanner(startTime);
        this.startTime = s.nextLong();
        s = new Scanner(stopTime);
        this.stopTime = s.nextLong();
        this.sessionID = sessionID;
        if (this.stopTime == Long.MIN_VALUE) {
            this.stopTime = null;
        }
    }

    public boolean isPaused() {
        return this.stopTime != null;
    }

    public void pause() {
        if (!this.isPaused()) {
            this.stopTime = System.currentTimeMillis();
        }
    }

    public void resume() {
        this.stopTime = null;
    }

    public Long getSessionDuration() {
        Long time = this.stopTime;
        if (time == null) {
            time = System.currentTimeMillis();
        }
        if (time < this.startTime) {
            return 0L;
        }
        Long sessionLength = -1L;
        try {
            sessionLength = time - this.startTime;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sessionLength;
    }

    public String generateSessionID(AnalyticsContext context) {
        String uniqID = context.getUniqueId().getValue();
        String time = this.sessionIdTimeFormat.format(this.startTime);
        return StringUtil.trimOrPadString(uniqID, 8, '_') + '-' + time;
    }

    @Override
    public JSONObject toJSONObject() {
        Long stopT = this.stopTime;
        if (stopT == null) {
            stopT = Long.MIN_VALUE;
        }
        JSONBuilder builder = new JSONBuilder(this);
        builder.withAttribute(JSON_SESSION_ID_ATTR, this.sessionID);
        builder.withAttribute(JSON_START_TIME_ATTR, this.startTime);
        builder.withAttribute(JSON_STOP_TIME_ATTR, stopT);
        return builder.toJSONObject();
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Long getStopTime() {
        return this.stopTime;
    }
}

