/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.DefaultSessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.SessionClientState;

public final class ActiveSessionState
extends SessionClientState {
    private static final String TAG = "ActiveSessoinState";

    public ActiveSessionState(DefaultSessionClient client) {
        super(client);
    }

    @Override
    public void resume() {
        Log.i((String)TAG, (String)"Session Resume Failed: Session is already running.");
    }

    @Override
    public void pause() {
        super.executePause();
    }

    @Override
    public void start() {
        if (System.currentTimeMillis() - this.client.session.getStartTime() > this.client.getRestartDelay()) {
            super.executeStop();
            super.executeStart();
        } else {
            Log.i((String)TAG, (String)"Session Start Failed: Previous session was started too recently");
        }
    }

    @Override
    public void stop() {
        super.executeStop();
    }
}

