/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization.MonetizationEventBuilder;

public class AmazonMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final String TAG = "AmazonMonetizationEventBuilder";

    public static AmazonMonetizationEventBuilder create(EventClient eventClient) {
        return new AmazonMonetizationEventBuilder(eventClient);
    }

    public AmazonMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public AmazonMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public AmazonMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    protected AmazonMonetizationEventBuilder(EventClient eventClient) {
        super(eventClient);
        this.setStore("Amazon");
    }

    @Override
    protected boolean isValid() {
        if (this.getProductId() == null) {
            Log.w((String)TAG, (String)"Amazon Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            Log.w((String)TAG, (String)"Amazon Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            Log.w((String)TAG, (String)"Amazon Monetization event is not valid: it is missing the formatted localized price");
            return false;
        }
        return true;
    }
}

