/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobileanalytics.model;

import com.amazonaws.services.mobileanalytics.model.Session;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Event
implements Serializable {
    private String eventType;
    private String timestamp;
    private Session session;
    private String version;
    private Map<String, String> attributes;
    private Map<String, Double> metrics;

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Event withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Event withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Event withSession(Session session) {
        this.session = session;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Event withVersion(String version) {
        this.version = version;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Event withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Event addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Event clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public Map<String, Double> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Double>();
        }
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public Event withMetrics(Map<String, Double> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public Event addMetricsEntry(String key, Double value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, Double>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public Event clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventType() != null) {
            sb.append("EventType: " + this.getEventType() + ",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: " + this.getTimestamp() + ",");
        }
        if (this.getSession() != null) {
            sb.append("Session: " + this.getSession() + ",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: " + this.getMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getSession() == null ? 0 : this.getSession().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getSession() == null ^ this.getSession() == null) {
            return false;
        }
        if (other.getSession() != null && !other.getSession().equals(this.getSession())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        return other.getMetrics() == null || other.getMetrics().equals(this.getMetrics());
    }
}

