/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobileanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.mobileanalytics.model.Event;
import com.amazonaws.services.mobileanalytics.model.PutEventsRequest;
import com.amazonaws.services.mobileanalytics.model.Session;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PutEventsRequestMarshaller
implements Marshaller<Request<PutEventsRequest>, PutEventsRequest> {
    public Request<PutEventsRequest> marshall(PutEventsRequest putEventsRequest) {
        if (putEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEventsRequest, "AmazonMobileAnalytics");
        String target = "AmazonMobileAnalytics.PutEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (putEventsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)putEventsRequest.getClientContext()));
        }
        if (putEventsRequest.getClientContextEncoding() != null) {
            request.addHeader("x-amz-Client-Context-Encoding", StringUtils.fromString((String)putEventsRequest.getClientContextEncoding()));
        }
        String uriResourcePath = "/2014-06-05/events";
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            ListWithAutoConstructFlag eventsList = (ListWithAutoConstructFlag)putEventsRequest.getEvents();
            if (!(eventsList == null || eventsList.isAutoConstruct() && eventsList.isEmpty())) {
                jsonWriter.name("events");
                jsonWriter.beginArray();
                for (Event eventsListValue : eventsList) {
                    Session session;
                    if (eventsListValue == null) continue;
                    jsonWriter.beginObject();
                    if (eventsListValue.getEventType() != null) {
                        jsonWriter.name("eventType").value(eventsListValue.getEventType());
                    }
                    if (eventsListValue.getTimestamp() != null) {
                        jsonWriter.name("timestamp").value(eventsListValue.getTimestamp());
                    }
                    if ((session = eventsListValue.getSession()) != null) {
                        jsonWriter.name("session");
                        jsonWriter.beginObject();
                        if (session.getId() != null) {
                            jsonWriter.name("id").value(session.getId());
                        }
                        if (session.getDuration() != null) {
                            jsonWriter.name("duration").value((Number)session.getDuration());
                        }
                        if (session.getStartTimestamp() != null) {
                            jsonWriter.name("startTimestamp").value(session.getStartTimestamp());
                        }
                        if (session.getStopTimestamp() != null) {
                            jsonWriter.name("stopTimestamp").value(session.getStopTimestamp());
                        }
                        jsonWriter.endObject();
                    }
                    if (eventsListValue.getVersion() != null) {
                        jsonWriter.name("version").value(eventsListValue.getVersion());
                    }
                    if (eventsListValue.getAttributes() != null) {
                        jsonWriter.name("attributes");
                        jsonWriter.beginObject();
                        for (Map.Entry<String, Object> entry : eventsListValue.getAttributes().entrySet()) {
                            if (entry.getValue() == null) continue;
                            jsonWriter.name(entry.getKey());
                            jsonWriter.value((String)entry.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    if (eventsListValue.getMetrics() != null) {
                        jsonWriter.name("metrics");
                        jsonWriter.beginObject();
                        for (Map.Entry<String, Object> entry : eventsListValue.getMetrics().entrySet()) {
                            if (entry.getValue() == null) continue;
                            jsonWriter.name(entry.getKey());
                            jsonWriter.value((Number)entry.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

