/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Connectivity;

public class AndroidConnectivity
implements Connectivity {
    private static final String TAG = "AndroidConnectivity";
    protected boolean hasWifi;
    protected boolean hasMobile;
    protected boolean hasWired;
    protected boolean inAirplaneMode;
    private Context context;

    public AndroidConnectivity(Context context) {
        this.context = context;
    }

    @Override
    public boolean isConnected() {
        this.determineAvailability();
        return this.hasWifi() || this.hasWAN() || this.hasWired();
    }

    @Override
    public boolean hasWifi() {
        return this.hasWifi;
    }

    @Override
    public boolean hasWAN() {
        return this.hasMobile && !this.inAirplaneMode;
    }

    @Override
    public boolean hasWired() {
        return this.hasWired;
    }

    private void determineAvailability() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        this.inAirplaneMode = Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        Log.v((String)TAG, (String)("Airplane mode: " + this.inAirplaneMode));
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        int networkType = 0;
        this.hasWifi = false;
        this.hasWired = false;
        boolean bl = this.hasMobile = cm != null;
        if (networkInfo != null) {
            if (networkInfo.isConnectedOrConnecting()) {
                networkType = networkInfo.getType();
                this.hasWired = networkType == 9;
                this.hasWifi = networkType == 1 || networkType == 6;
                this.hasMobile = networkType == 0 || networkType == 4 || networkType == 5 || networkType == 2 || networkType == 3;
            } else {
                this.hasMobile = false;
            }
        }
        Log.v((String)TAG, (String)String.format("Device Connectivity (%s)", this.hasWifi ? "On Wifi" : (this.hasMobile ? "On Mobile" : "No network connectivity")));
    }
}

