/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultFileManager
implements FileManager {
    private final File directory;

    public DefaultFileManager(File rootDirectory) {
        this.directory = rootDirectory;
    }

    @Override
    public synchronized File createDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        if (dir.mkdirs() || dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    @Override
    public File getDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return dir;
    }

    @Override
    public Set<File> listFilesInDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return this.listFilesInDirectory(dir);
    }

    @Override
    public Set<File> listFilesInDirectory(File directory) {
        HashSet<File> filesSet = new HashSet<File>();
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                filesSet.add(file);
            }
        }
        return Collections.unmodifiableSet(filesSet);
    }

    @Override
    public synchronized File createFile(String filepath) throws IOException {
        File file = new File(this.directory, filepath);
        return this.createFile(file);
    }

    @Override
    public synchronized File createFile(File file) throws IOException {
        if (file.createNewFile() || file.isFile()) {
            return file;
        }
        return null;
    }

    @Override
    public synchronized boolean deleteFile(String filepath) {
        File file = new File(this.directory, filepath);
        return this.deleteFile(file);
    }

    @Override
    public synchronized boolean deleteFile(File file) {
        return file.delete() || !file.exists();
    }

    @Override
    public synchronized InputStream newInputStream(String filepath) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newInputStream(file);
    }

    @Override
    public synchronized InputStream newInputStream(File file) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        return stream;
    }

    @Override
    public synchronized OutputStream newOutputStream(String filepath, boolean append) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newOutputStream(file, append);
    }

    @Override
    public synchronized OutputStream newOutputStream(File file, boolean append) throws FileNotFoundException {
        FileOutputStream stream = new FileOutputStream(file, append);
        return stream;
    }
}

