/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStoreException;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;

public class FileEventStore
implements EventStore {
    private static final String TAG = "FileEventStore";
    static final String EVENTS_DIRECTORY = "events";
    static final String EVENT_FILE_NAME = "eventsFile";
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final double ERROR_LENGTH_THRESHOLD_PERCENTAGE = 1.1;
    private final ReentrantLock accessLock = new ReentrantLock(true);
    static long MAX_STORAGE_SIZE = 0x500000L;
    private final AnalyticsContext context;
    private File eventsFile;

    public static FileEventStore newInstance(AnalyticsContext context) {
        return new FileEventStore(context);
    }

    public FileEventStore(AnalyticsContext context) {
        this.context = context;
        this.tryCreateEventsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String event) throws EventStoreException {
        boolean success = false;
        BufferedWriter writer = null;
        this.accessLock.lock();
        try {
            writer = this.tryInitializeWriter();
            if (writer != null) {
                long maxStorageSize = this.context.getConfiguration().optLong(KEY_MAX_STORAGE_SIZE, MAX_STORAGE_SIZE);
                if (this.eventsFile.length() + (long)event.length() <= maxStorageSize) {
                    writer.write(event);
                    writer.newLine();
                    writer.flush();
                    success = true;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to persist the event", (Throwable)e);
        }
        finally {
            this.tryCloseWriter(writer);
            this.accessLock.unlock();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCreateEventsFile() {
        if (this.eventsFile != null && this.eventsFile.exists()) {
            return true;
        }
        FileEventStore fileEventStore = this;
        synchronized (fileEventStore) {
            if (this.eventsFile != null && this.eventsFile.exists()) {
                return true;
            }
            try {
                FileManager fileManager = this.context.getSystem().getFileManager();
                File eventsDir = fileManager.createDirectory(EVENTS_DIRECTORY);
                this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                return true;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to open events file");
                Log.e((String)TAG, (String)"An error occurred while attempting to create/open the events file", (Throwable)e);
                return false;
            }
        }
    }

    private BufferedWriter tryInitializeWriter() throws EventStoreException {
        BufferedWriter writer = null;
        try {
            if (!this.tryCreateEventsFile()) {
                throw new EventStoreException("Unable to create eventsFile");
            }
            OutputStream stream = this.context.getSystem().getFileManager().newOutputStream(this.eventsFile, true);
            writer = new BufferedWriter(new OutputStreamWriter(stream, StringUtils.UTF8));
        }
        catch (EventStoreException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Events file not found to persist event to", (Throwable)e);
            throw new EventStoreException("Unable to open events file writer", e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Unexpected exception", (Throwable)e);
            throw new EventStoreException("Unexpected error while creating eventsFile writer", e);
        }
        return writer;
    }

    private void tryCloseWriter(Writer writer) throws EventStoreException {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to close writer for events file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File deleteReadEvents(int lineNumber) {
        FileManager fileManager = this.context.getSystem().getFileManager();
        File eventsDir = fileManager.createDirectory(EVENTS_DIRECTORY);
        File tempEventsFile = null;
        try {
            File tempFile = new File(eventsDir, "eventsFile.tmp");
            if (tempFile.exists() && !tempFile.delete()) {
                Log.e((String)TAG, (String)"Failed to delete previous temp file");
            }
            tempEventsFile = fileManager.createFile(tempFile);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"An error occurred while attempting to create/open the temporary events file", (Throwable)e);
            return this.eventsFile;
        }
        boolean errorsOccurred = false;
        if (tempEventsFile != null && this.eventsFile.exists() && tempEventsFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(this.eventsFile));
                writer = new PrintWriter(new FileWriter(tempEventsFile, true));
                String line = null;
                int currentLineNumber = 0;
                while ((line = reader.readLine()) != null) {
                    if (++currentLineNumber <= lineNumber) continue;
                    writer.println(line);
                    writer.flush();
                }
            }
            catch (FileNotFoundException e) {
                errorsOccurred = true;
                Log.e((String)TAG, (String)"The events file count not be found", (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"An error occurred while attempting to delete the read events", (Throwable)e);
                errorsOccurred = true;
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
                if (!errorsOccurred) {
                    if (this.eventsFile.delete()) {
                        if (!tempEventsFile.renameTo(this.eventsFile)) {
                            Log.e((String)TAG, (String)"Failed to rename temp file to events file");
                        }
                        try {
                            this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)"An error occurred while attempting to create the eventsFile", (Throwable)e);
                        }
                    } else {
                        Log.e((String)TAG, (String)"Failed to delete previous events file");
                    }
                }
            }
            File tempFile = new File(eventsDir, "eventsFile.tmp");
            if (tempFile.exists() && !tempFile.delete()) {
                Log.e((String)TAG, (String)"Failed to delete temp file");
            }
        }
        return this.eventsFile;
    }

    @Override
    public EventStore.EventIterator iterator() {
        return new EventStore.EventIterator(){
            int linesRead = 0;
            String nextBuffer = null;
            BufferedReader reader = null;
            boolean isEndOfFile = false;

            private boolean tryOpenReader() {
                if (this.reader != null) {
                    return true;
                }
                if (!this.isEndOfFile) {
                    InputStreamReader streamReader = null;
                    try {
                        streamReader = new InputStreamReader(FileEventStore.this.context.getSystem().getFileManager().newInputStream(FileEventStore.this.eventsFile), StringUtils.UTF8);
                    }
                    catch (FileNotFoundException e) {
                        Log.e((String)FileEventStore.TAG, (String)"Could not open the events file", (Throwable)e);
                    }
                    if (streamReader != null) {
                        this.reader = new BufferedReader(streamReader);
                        return true;
                    }
                }
                return false;
            }

            private void tryCloseReader() {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException ioe) {
                        Log.e((String)FileEventStore.TAG, (String)"Unable to close reader for events file", (Throwable)ioe);
                    }
                    finally {
                        this.reader = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                FileEventStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        hasNext = true;
                    } else {
                        if (!this.tryOpenReader()) {
                            boolean bl = hasNext;
                            return bl;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                this.nextBuffer = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                this.nextBuffer = null;
                                found = true;
                            }
                        }
                        if (this.nextBuffer != null) {
                            hasNext = true;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    boolean bl = hasNext;
                    return bl;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String next() {
                String next = null;
                FileEventStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        next = this.nextBuffer;
                        ++this.linesRead;
                        this.nextBuffer = null;
                    } else {
                        if (!this.tryOpenReader()) {
                            String string = next;
                            return string;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                next = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                next = null;
                                found = true;
                            }
                        }
                        if (next != null) {
                            ++this.linesRead;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    String string = next;
                    return string;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            @Override
            public String peek() {
                FileEventStore.this.accessLock.lock();
                try {
                    this.hasNext();
                    String string = this.nextBuffer;
                    return string;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove() operation is not supported for this iterator");
            }

            @Override
            public void removeReadEvents() {
                FileEventStore.this.accessLock.lock();
                try {
                    FileEventStore.this.deleteReadEvents(this.linesRead);
                    this.resetReader();
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            private void resetReader() {
                this.tryCloseReader();
                this.linesRead = 0;
                this.nextBuffer = null;
            }
        };
    }
}

