/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization.MonetizationEventBuilder;

public class GooglePlayMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final String TAG = "GooglePlayMonetizationEventBuilder";

    public static GooglePlayMonetizationEventBuilder create(EventClient eventClient) {
        return new GooglePlayMonetizationEventBuilder(eventClient);
    }

    public GooglePlayMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    protected GooglePlayMonetizationEventBuilder(EventClient eventClient) {
        super(eventClient);
        this.setStore("Google Play");
    }

    @Override
    protected boolean isValid() {
        if (this.getProductId() == null) {
            Log.w((String)TAG, (String)"Cannot build Google Monetization event: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            Log.w((String)TAG, (String)"Google Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            Log.w((String)TAG, (String)"Google Monetization event is not valid: it is missing the formatted localized price");
            return false;
        }
        if (this.getTransactionId() == null) {
            Log.w((String)TAG, (String)"Google Monetization event is not valid: it is missing the transaction id");
            return false;
        }
        return true;
    }
}

