/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.services.polly.AmazonPolly;
import com.amazonaws.services.polly.AmazonPollyClient;
import com.amazonaws.services.polly.internal.AmazonPollyCustomPresigner;
import com.amazonaws.services.polly.internal.PresigningRequest;
import com.amazonaws.services.polly.internal.ServiceUtils;
import com.amazonaws.services.polly.model.SynthesizeSpeechPresignRequest;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechPresignRequestMarshaller;
import java.net.URL;
import java.util.Date;

public class AmazonPollyPresigningClient
extends AmazonPollyClient
implements AmazonPolly {
    private static final int DEFAULT_GET_REQUEST_EXPIRATION_MINUTES = 15;
    private AWSCredentialsProvider awsCredentialsProvider;

    public AmazonPollyPresigningClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonPollyPresigningClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    public AmazonPollyPresigningClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        super(awsCredentialsProvider, clientConfiguration, httpClient);
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    public URL getPresignedSynthesizeSpeechUrl(SynthesizeSpeechPresignRequest synthesizeSpeechPresignRequest) {
        Signer signer;
        Request<PresigningRequest> request = new SynthesizeSpeechPresignRequestMarshaller().marshall(synthesizeSpeechPresignRequest);
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        if (synthesizeSpeechPresignRequest.getExpiration() == null) {
            synthesizeSpeechPresignRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        if (!((signer = this.getSignerByURI(this.endpoint)) instanceof Presigner)) {
            throw new AmazonClientException("Unsupported signer");
        }
        Presigner presigner = (Presigner)signer;
        Date expirationDate = synthesizeSpeechPresignRequest.getExpiration();
        AWSCredentials credentials = synthesizeSpeechPresignRequest.getRequestCredentials();
        if (credentials == null) {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        presigner.presignRequest(request, credentials, expirationDate);
        return ServiceUtils.convertRequestToUrl(request, true);
    }

    static {
        SignerFactory.registerSigner((String)"AmazonPollyCustomPresigner", AmazonPollyCustomPresigner.class);
    }
}

