/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVoicesRequestMarshaller
implements Marshaller<Request<DescribeVoicesRequest>, DescribeVoicesRequest> {
    public Request<DescribeVoicesRequest> marshall(DescribeVoicesRequest describeVoicesRequest) {
        if (describeVoicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeVoicesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVoicesRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/voices";
        if (describeVoicesRequest.getLanguageCode() != null) {
            request.addParameter("LanguageCode", StringUtils.fromString((String)describeVoicesRequest.getLanguageCode()));
        }
        if (describeVoicesRequest.getIncludeAdditionalLanguageCodes() != null) {
            request.addParameter("IncludeAdditionalLanguageCodes", StringUtils.fromBoolean((Boolean)describeVoicesRequest.getIncludeAdditionalLanguageCodes()));
        }
        if (describeVoicesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVoicesRequest.getNextToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

