/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.services.polly.model.LexiconAttributes;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class LexiconAttributesJsonUnmarshaller
implements Unmarshaller<LexiconAttributes, JsonUnmarshallerContext> {
    private static LexiconAttributesJsonUnmarshaller instance;

    LexiconAttributesJsonUnmarshaller() {
    }

    public LexiconAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        LexiconAttributes lexiconAttributes = new LexiconAttributes();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Alphabet")) {
                lexiconAttributes.setAlphabet(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LanguageCode")) {
                lexiconAttributes.setLanguageCode(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LastModified")) {
                lexiconAttributes.setLastModified(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LexiconArn")) {
                lexiconAttributes.setLexiconArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LexemesCount")) {
                lexiconAttributes.setLexemesCount(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Size")) {
                lexiconAttributes.setSize(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return lexiconAttributes;
    }

    public static LexiconAttributesJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LexiconAttributesJsonUnmarshaller();
        }
        return instance;
    }
}

