/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutLexiconRequestMarshaller
implements Marshaller<Request<PutLexiconRequest>, PutLexiconRequest> {
    public Request<PutLexiconRequest> marshall(PutLexiconRequest putLexiconRequest) {
        if (putLexiconRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutLexiconRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putLexiconRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/lexicons/{LexiconName}";
        uriResourcePath = uriResourcePath.replace("{LexiconName}", putLexiconRequest.getName() == null ? "" : StringUtils.fromString((String)putLexiconRequest.getName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (putLexiconRequest.getContent() != null) {
                String content = putLexiconRequest.getContent();
                jsonWriter.name("Content");
                jsonWriter.value(content);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

