/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetLexiconRequestMarshaller
implements Marshaller<Request<GetLexiconRequest>, GetLexiconRequest> {
    public Request<GetLexiconRequest> marshall(GetLexiconRequest getLexiconRequest) {
        if (getLexiconRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetLexiconRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getLexiconRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/lexicons/{LexiconName}";
        uriResourcePath = uriResourcePath.replace("{LexiconName}", getLexiconRequest.getName() == null ? "" : StringUtils.fromString((String)getLexiconRequest.getName()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

