/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.services.polly.internal.AmazonPollyCustomRequest;
import com.amazonaws.util.HttpUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceUtils {
    public static URL convertRequestToUrl(Request<?> request, boolean removeLeadingSlashInResourcePath) {
        String resourcePath = HttpUtils.urlEncode((String)request.getResourcePath(), (boolean)true);
        if (removeLeadingSlashInResourcePath && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        String urlString = request.getEndpoint() + urlPath;
        boolean firstParam = true;
        Map<Object, Object> parameters = request.getParameters();
        Map<String, List<String>> parametersWithList = null;
        if (request instanceof AmazonPollyCustomRequest) {
            parametersWithList = ((AmazonPollyCustomRequest)request).getParametersWithList();
        }
        for (String param : (parametersWithList == null ? parameters : parametersWithList).keySet()) {
            if (firstParam) {
                urlString = urlString + "?";
                firstParam = false;
            } else {
                urlString = urlString + "&";
            }
            if (parametersWithList != null) {
                List<String> values = parametersWithList.get(param);
                Collections.sort(values);
                Iterator<String> iter = values.iterator();
                while (iter.hasNext()) {
                    urlString = urlString + param + "=" + HttpUtils.urlEncode((String)iter.next().toString(), (boolean)false);
                    if (!iter.hasNext()) continue;
                    urlString = urlString + "&";
                }
                continue;
            }
            String value = (String)parameters.get(param);
            urlString = urlString + param + "=" + HttpUtils.urlEncode((String)value.toString(), (boolean)false);
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new AmazonClientException("Unable to convert request to well formed URL: " + e.getMessage(), (Throwable)e);
        }
    }
}

