/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class StartSpeechSynthesisTaskRequestMarshaller
implements Marshaller<Request<StartSpeechSynthesisTaskRequest>, StartSpeechSynthesisTaskRequest> {
    public Request<StartSpeechSynthesisTaskRequest> marshall(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) {
        if (startSpeechSynthesisTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(StartSpeechSynthesisTaskRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startSpeechSynthesisTaskRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/synthesisTasks";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (startSpeechSynthesisTaskRequest.getEngine() != null) {
                String engine = startSpeechSynthesisTaskRequest.getEngine();
                jsonWriter.name("Engine");
                jsonWriter.value(engine);
            }
            if (startSpeechSynthesisTaskRequest.getLanguageCode() != null) {
                String languageCode = startSpeechSynthesisTaskRequest.getLanguageCode();
                jsonWriter.name("LanguageCode");
                jsonWriter.value(languageCode);
            }
            if (startSpeechSynthesisTaskRequest.getLexiconNames() != null) {
                List<String> lexiconNames = startSpeechSynthesisTaskRequest.getLexiconNames();
                jsonWriter.name("LexiconNames");
                jsonWriter.beginArray();
                for (String lexiconNamesItem : lexiconNames) {
                    if (lexiconNamesItem == null) continue;
                    jsonWriter.value(lexiconNamesItem);
                }
                jsonWriter.endArray();
            }
            if (startSpeechSynthesisTaskRequest.getOutputFormat() != null) {
                String outputFormat = startSpeechSynthesisTaskRequest.getOutputFormat();
                jsonWriter.name("OutputFormat");
                jsonWriter.value(outputFormat);
            }
            if (startSpeechSynthesisTaskRequest.getOutputS3BucketName() != null) {
                String outputS3BucketName = startSpeechSynthesisTaskRequest.getOutputS3BucketName();
                jsonWriter.name("OutputS3BucketName");
                jsonWriter.value(outputS3BucketName);
            }
            if (startSpeechSynthesisTaskRequest.getOutputS3KeyPrefix() != null) {
                String outputS3KeyPrefix = startSpeechSynthesisTaskRequest.getOutputS3KeyPrefix();
                jsonWriter.name("OutputS3KeyPrefix");
                jsonWriter.value(outputS3KeyPrefix);
            }
            if (startSpeechSynthesisTaskRequest.getSampleRate() != null) {
                String sampleRate = startSpeechSynthesisTaskRequest.getSampleRate();
                jsonWriter.name("SampleRate");
                jsonWriter.value(sampleRate);
            }
            if (startSpeechSynthesisTaskRequest.getSnsTopicArn() != null) {
                String snsTopicArn = startSpeechSynthesisTaskRequest.getSnsTopicArn();
                jsonWriter.name("SnsTopicArn");
                jsonWriter.value(snsTopicArn);
            }
            if (startSpeechSynthesisTaskRequest.getSpeechMarkTypes() != null) {
                List<String> speechMarkTypes = startSpeechSynthesisTaskRequest.getSpeechMarkTypes();
                jsonWriter.name("SpeechMarkTypes");
                jsonWriter.beginArray();
                for (String speechMarkTypesItem : speechMarkTypes) {
                    if (speechMarkTypesItem == null) continue;
                    jsonWriter.value(speechMarkTypesItem);
                }
                jsonWriter.endArray();
            }
            if (startSpeechSynthesisTaskRequest.getText() != null) {
                String text = startSpeechSynthesisTaskRequest.getText();
                jsonWriter.name("Text");
                jsonWriter.value(text);
            }
            if (startSpeechSynthesisTaskRequest.getTextType() != null) {
                String textType = startSpeechSynthesisTaskRequest.getTextType();
                jsonWriter.name("TextType");
                jsonWriter.value(textType);
            }
            if (startSpeechSynthesisTaskRequest.getVoiceId() != null) {
                String voiceId = startSpeechSynthesisTaskRequest.getVoiceId();
                jsonWriter.name("VoiceId");
                jsonWriter.value(voiceId);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

