/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.services.polly.model.SynthesisTask;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class SynthesisTaskJsonMarshaller {
    private static SynthesisTaskJsonMarshaller instance;

    SynthesisTaskJsonMarshaller() {
    }

    public void marshall(SynthesisTask synthesisTask, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (synthesisTask.getEngine() != null) {
            String engine = synthesisTask.getEngine();
            jsonWriter.name("Engine");
            jsonWriter.value(engine);
        }
        if (synthesisTask.getTaskId() != null) {
            String taskId = synthesisTask.getTaskId();
            jsonWriter.name("TaskId");
            jsonWriter.value(taskId);
        }
        if (synthesisTask.getTaskStatus() != null) {
            String taskStatus = synthesisTask.getTaskStatus();
            jsonWriter.name("TaskStatus");
            jsonWriter.value(taskStatus);
        }
        if (synthesisTask.getTaskStatusReason() != null) {
            String taskStatusReason = synthesisTask.getTaskStatusReason();
            jsonWriter.name("TaskStatusReason");
            jsonWriter.value(taskStatusReason);
        }
        if (synthesisTask.getOutputUri() != null) {
            String outputUri = synthesisTask.getOutputUri();
            jsonWriter.name("OutputUri");
            jsonWriter.value(outputUri);
        }
        if (synthesisTask.getCreationTime() != null) {
            Date creationTime = synthesisTask.getCreationTime();
            jsonWriter.name("CreationTime");
            jsonWriter.value(creationTime);
        }
        if (synthesisTask.getRequestCharacters() != null) {
            Integer requestCharacters = synthesisTask.getRequestCharacters();
            jsonWriter.name("RequestCharacters");
            jsonWriter.value((Number)requestCharacters);
        }
        if (synthesisTask.getSnsTopicArn() != null) {
            String snsTopicArn = synthesisTask.getSnsTopicArn();
            jsonWriter.name("SnsTopicArn");
            jsonWriter.value(snsTopicArn);
        }
        if (synthesisTask.getLexiconNames() != null) {
            List<String> lexiconNames = synthesisTask.getLexiconNames();
            jsonWriter.name("LexiconNames");
            jsonWriter.beginArray();
            for (String lexiconNamesItem : lexiconNames) {
                if (lexiconNamesItem == null) continue;
                jsonWriter.value(lexiconNamesItem);
            }
            jsonWriter.endArray();
        }
        if (synthesisTask.getOutputFormat() != null) {
            String outputFormat = synthesisTask.getOutputFormat();
            jsonWriter.name("OutputFormat");
            jsonWriter.value(outputFormat);
        }
        if (synthesisTask.getSampleRate() != null) {
            String sampleRate = synthesisTask.getSampleRate();
            jsonWriter.name("SampleRate");
            jsonWriter.value(sampleRate);
        }
        if (synthesisTask.getSpeechMarkTypes() != null) {
            List<String> speechMarkTypes = synthesisTask.getSpeechMarkTypes();
            jsonWriter.name("SpeechMarkTypes");
            jsonWriter.beginArray();
            for (String speechMarkTypesItem : speechMarkTypes) {
                if (speechMarkTypesItem == null) continue;
                jsonWriter.value(speechMarkTypesItem);
            }
            jsonWriter.endArray();
        }
        if (synthesisTask.getTextType() != null) {
            String textType = synthesisTask.getTextType();
            jsonWriter.name("TextType");
            jsonWriter.value(textType);
        }
        if (synthesisTask.getVoiceId() != null) {
            String voiceId = synthesisTask.getVoiceId();
            jsonWriter.name("VoiceId");
            jsonWriter.value(voiceId);
        }
        if (synthesisTask.getLanguageCode() != null) {
            String languageCode = synthesisTask.getLanguageCode();
            jsonWriter.name("LanguageCode");
            jsonWriter.value(languageCode);
        }
        jsonWriter.endObject();
    }

    public static SynthesisTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SynthesisTaskJsonMarshaller();
        }
        return instance;
    }
}

