/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.internal.AmazonPollyCustomRequest;
import com.amazonaws.services.polly.internal.PresigningRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechPresignRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SynthesizeSpeechPresignRequestMarshaller
implements Marshaller<Request<PresigningRequest>, SynthesizeSpeechPresignRequest> {
    private static final String URI_RESOURCE_PATH = "/v1/speech";

    public Request<PresigningRequest> marshall(SynthesizeSpeechPresignRequest synthesizeSpeechPresignRequest) {
        List<String> lexiconNames;
        if (synthesizeSpeechPresignRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SynthesizeSpeechRequest)");
        }
        AmazonPollyCustomRequest request = new AmazonPollyCustomRequest(new PresigningRequest().withRequestCredentials(synthesizeSpeechPresignRequest.getRequestCredentials()), "AmazonPolly");
        request.setHttpMethod(HttpMethodName.GET);
        request.setResourcePath(URI_RESOURCE_PATH);
        List<String> speechMarkTypes = synthesizeSpeechPresignRequest.getSpeechMarkTypes();
        if (speechMarkTypes != null && speechMarkTypes.size() > 0) {
            for (String speechMarkType : speechMarkTypes) {
                request.addParameter("SpeechMarkTypes", speechMarkType);
            }
        }
        if ((lexiconNames = synthesizeSpeechPresignRequest.getLexiconNames()) != null && lexiconNames.size() > 0) {
            for (String lexicon : lexiconNames) {
                request.addParameter("LexiconNames", lexicon);
            }
        }
        if (synthesizeSpeechPresignRequest.getText() != null) {
            request.addParameter("Text", synthesizeSpeechPresignRequest.getText());
        }
        if (synthesizeSpeechPresignRequest.getTextType() != null) {
            request.addParameter("TextType", StringUtils.fromString((String)synthesizeSpeechPresignRequest.getTextType()));
        }
        if (synthesizeSpeechPresignRequest.getVoiceId() != null) {
            request.addParameter("VoiceId", StringUtils.fromString((String)synthesizeSpeechPresignRequest.getVoiceId()));
        }
        if (synthesizeSpeechPresignRequest.getLanguageCode() != null) {
            request.addParameter("LanguageCode", StringUtils.fromString((String)synthesizeSpeechPresignRequest.getLanguageCode()));
        }
        if (synthesizeSpeechPresignRequest.getSampleRate() != null) {
            request.addParameter("SampleRate", synthesizeSpeechPresignRequest.getSampleRate());
        }
        if (synthesizeSpeechPresignRequest.getOutputFormat() != null) {
            request.addParameter("OutputFormat", synthesizeSpeechPresignRequest.getOutputFormat());
        }
        if (synthesizeSpeechPresignRequest.getEngine() != null) {
            request.addParameter("Engine", synthesizeSpeechPresignRequest.getEngine().toString());
        }
        return request;
    }
}

