/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.polly.AmazonPolly;
import com.amazonaws.services.polly.model.DeleteLexiconRequest;
import com.amazonaws.services.polly.model.DeleteLexiconResult;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.DescribeVoicesResult;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.services.polly.model.GetLexiconResult;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.services.polly.model.ListLexiconsResult;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.services.polly.model.PutLexiconResult;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechResult;
import com.amazonaws.services.polly.model.transform.DeleteLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.DeleteLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesRequestMarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidLexiconExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidSampleRateExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidSsmlExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.LexiconNotFoundExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.LexiconSizeExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsRequestMarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.MarksNotSupportedForFormatExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.MaxLexemeLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.MaxLexiconsNumberExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconRequestMarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.ServiceFailureExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.SsmlMarksNotSupportedForTextTypeExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechRequestMarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.TextLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.UnsupportedPlsAlphabetExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.UnsupportedPlsLanguageExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;

public class AmazonPollyClient
extends AmazonWebServiceClient
implements AmazonPolly {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    @Deprecated
    public AmazonPollyClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    @Deprecated
    public AmazonPollyClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonPollyClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonPollyClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(awsCredentials), clientConfiguration);
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonPollyClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        super(AmazonPollyClient.adjustClientConfiguration(clientConfiguration), httpClient);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new InvalidLexiconExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidSampleRateExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidSsmlExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LexiconNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LexiconSizeExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MarksNotSupportedForFormatExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxLexemeLengthExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxLexiconsNumberExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServiceFailureExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new SsmlMarksNotSupportedForTextTypeExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TextLengthExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedPlsAlphabetExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedPlsLanguageExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("https://polly.us-east-1.amazonaws.com");
        this.endpointPrefix = "polly";
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/polly/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/polly/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLexiconResult deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLexiconRequestMarshaller().marshall(deleteLexiconRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteLexiconResultJsonUnmarshaller unmarshaller = new DeleteLexiconResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteLexiconResult deleteLexiconResult = (DeleteLexiconResult)response.getAwsResponse();
            return deleteLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVoicesResult describeVoices(DescribeVoicesRequest describeVoicesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeVoicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVoicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVoicesRequestMarshaller().marshall(describeVoicesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeVoicesResultJsonUnmarshaller unmarshaller = new DescribeVoicesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeVoicesResult describeVoicesResult = (DescribeVoicesResult)response.getAwsResponse();
            return describeVoicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLexiconResult getLexicon(GetLexiconRequest getLexiconRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLexiconRequestMarshaller().marshall(getLexiconRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetLexiconResultJsonUnmarshaller unmarshaller = new GetLexiconResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetLexiconResult getLexiconResult = (GetLexiconResult)response.getAwsResponse();
            return getLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLexiconsResult listLexicons(ListLexiconsRequest listLexiconsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listLexiconsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLexiconsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLexiconsRequestMarshaller().marshall(listLexiconsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListLexiconsResultJsonUnmarshaller unmarshaller = new ListLexiconsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListLexiconsResult listLexiconsResult = (ListLexiconsResult)response.getAwsResponse();
            return listLexiconsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLexiconResult putLexicon(PutLexiconRequest putLexiconRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(putLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLexiconRequestMarshaller().marshall(putLexiconRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PutLexiconResultJsonUnmarshaller unmarshaller = new PutLexiconResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutLexiconResult putLexiconResult = (PutLexiconResult)response.getAwsResponse();
            return putLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynthesizeSpeechResult synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(synthesizeSpeechRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SynthesizeSpeechRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SynthesizeSpeechRequestMarshaller().marshall(synthesizeSpeechRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SynthesizeSpeechResultJsonUnmarshaller unmarshaller = new SynthesizeSpeechResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SynthesizeSpeechResult synthesizeSpeechResult = (SynthesizeSpeechResult)response.getAwsResponse();
            return synthesizeSpeechResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    @Deprecated
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

