/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.internal;

import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.services.polly.internal.AmazonPollyCustomRequest;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AmazonPollyCustomPresigner
extends AWS4Signer {
    private static final String DEFAULT_ENCODING = "UTF-8";

    protected InputStream getBinaryRequestPayloadStream(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = AmazonPollyCustomPresigner.encodeParameters(request);
            if (encodedParameters == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(encodedParameters.getBytes(StringUtils.UTF8));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    public static String encodeParameters(Request<?> request) {
        AmazonPollyCustomRequest customRequest = (AmazonPollyCustomRequest)request;
        Map<String, List<String>> parametersWithList = customRequest.getParametersWithList();
        if (parametersWithList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String parameterSeparator = "";
        try {
            for (Map.Entry<String, List<String>> entry : parametersWithList.entrySet()) {
                String encodedName = URLEncoder.encode(entry.getKey(), DEFAULT_ENCODING);
                List<String> values = entry.getValue();
                if (values == null) continue;
                sb.append(parameterSeparator);
                parameterSeparator = "&";
                String valueSeparator = "";
                for (String value : values) {
                    sb.append(valueSeparator);
                    valueSeparator = "&";
                    String encodedValue = URLEncoder.encode(value, DEFAULT_ENCODING);
                    sb.append(encodedName).append("=").append(encodedValue);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return sb.toString();
    }

    protected String getCanonicalizedQueryString(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        if (AmazonPollyCustomRequest.class.equals(request.getClass())) {
            return this.getCanonicalizedQueryStringForListParameters(((AmazonPollyCustomRequest)request).getParametersWithList());
        }
        return this.getCanonicalizedQueryString(request.getParameters());
    }

    protected String getCanonicalizedQueryStringForListParameters(Map<String, List<String>> parameters) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> sortedKeys = new ArrayList<String>(parameters.keySet());
        Collections.sort(sortedKeys);
        Iterator<String> keyIter = sortedKeys.iterator();
        while (keyIter.hasNext()) {
            String key = keyIter.next();
            List<String> values = parameters.get(key);
            String urlEncodedKey = HttpUtils.urlEncode((String)key, (boolean)false);
            Collections.sort(values);
            Iterator<String> valuesIter = values.iterator();
            while (valuesIter.hasNext()) {
                builder.append(urlEncodedKey).append("=").append(HttpUtils.urlEncode((String)valuesIter.next(), (boolean)false));
                if (!valuesIter.hasNext()) continue;
                builder.append("&");
            }
            if (!keyIter.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }
}

