/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class SynthesizeSpeechRequestMarshaller
implements Marshaller<Request<SynthesizeSpeechRequest>, SynthesizeSpeechRequest> {
    public Request<SynthesizeSpeechRequest> marshall(SynthesizeSpeechRequest synthesizeSpeechRequest) {
        if (synthesizeSpeechRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SynthesizeSpeechRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)synthesizeSpeechRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/speech";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (synthesizeSpeechRequest.getLexiconNames() != null) {
                List<String> lexiconNames = synthesizeSpeechRequest.getLexiconNames();
                jsonWriter.name("LexiconNames");
                jsonWriter.beginArray();
                for (String lexiconNamesItem : lexiconNames) {
                    if (lexiconNamesItem == null) continue;
                    jsonWriter.value(lexiconNamesItem);
                }
                jsonWriter.endArray();
            }
            if (synthesizeSpeechRequest.getOutputFormat() != null) {
                String outputFormat = synthesizeSpeechRequest.getOutputFormat();
                jsonWriter.name("OutputFormat");
                jsonWriter.value(outputFormat);
            }
            if (synthesizeSpeechRequest.getSampleRate() != null) {
                String sampleRate = synthesizeSpeechRequest.getSampleRate();
                jsonWriter.name("SampleRate");
                jsonWriter.value(sampleRate);
            }
            if (synthesizeSpeechRequest.getSpeechMarkTypes() != null) {
                List<String> speechMarkTypes = synthesizeSpeechRequest.getSpeechMarkTypes();
                jsonWriter.name("SpeechMarkTypes");
                jsonWriter.beginArray();
                for (String speechMarkTypesItem : speechMarkTypes) {
                    if (speechMarkTypesItem == null) continue;
                    jsonWriter.value(speechMarkTypesItem);
                }
                jsonWriter.endArray();
            }
            if (synthesizeSpeechRequest.getText() != null) {
                String text = synthesizeSpeechRequest.getText();
                jsonWriter.name("Text");
                jsonWriter.value(text);
            }
            if (synthesizeSpeechRequest.getTextType() != null) {
                String textType = synthesizeSpeechRequest.getTextType();
                jsonWriter.name("TextType");
                jsonWriter.value(textType);
            }
            if (synthesizeSpeechRequest.getVoiceId() != null) {
                String voiceId = synthesizeSpeechRequest.getVoiceId();
                jsonWriter.name("VoiceId");
                jsonWriter.value(voiceId);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

