/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferMonitor;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferStateChangeListener;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ProgressListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTransfer
implements Transfer {
    protected volatile Transfer.TransferState state = Transfer.TransferState.Waiting;
    protected TransferMonitor monitor;
    private final TransferProgress transferProgress;
    private final String description;
    protected final ProgressListenerChain progressListenerChain;
    protected final Collection<TransferStateChangeListener> stateChangeListeners = new LinkedList<TransferStateChangeListener>();

    AbstractTransfer(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        this(string, transferProgress, progressListenerChain, null);
    }

    AbstractTransfer(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener transferStateChangeListener) {
        this.description = string;
        this.progressListenerChain = progressListenerChain;
        this.transferProgress = transferProgress;
        this.addStateChangeListener(transferStateChangeListener);
    }

    @Override
    public synchronized boolean isDone() {
        return this.state == Transfer.TransferState.Failed || this.state == Transfer.TransferState.Completed || this.state == Transfer.TransferState.Canceled;
    }

    @Override
    public void waitForCompletion() throws AmazonClientException, AmazonServiceException, InterruptedException {
        try {
            Object var1_1 = null;
            while (!this.monitor.isDone() || var1_1 == null) {
                Future<?> future = this.monitor.getFuture();
                var1_1 = future.get();
            }
        }
        catch (ExecutionException executionException) {
            this.rethrowExecutionException(executionException);
        }
    }

    @Override
    public AmazonClientException waitForException() throws InterruptedException {
        try {
            while (!this.monitor.isDone()) {
                this.monitor.getFuture().get();
            }
            this.monitor.getFuture().get();
            return null;
        }
        catch (ExecutionException executionException) {
            return this.unwrapExecutionException(executionException);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized Transfer.TransferState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Transfer.TransferState transferState) {
        AbstractTransfer abstractTransfer = this;
        synchronized (abstractTransfer) {
            this.state = transferState;
        }
        for (TransferStateChangeListener transferStateChangeListener : this.stateChangeListeners) {
            transferStateChangeListener.transferStateChanged(this, transferState);
        }
    }

    public void notifyStateChangeListeners(Transfer.TransferState transferState) {
        for (TransferStateChangeListener transferStateChangeListener : this.stateChangeListeners) {
            transferStateChangeListener.transferStateChanged(this, transferState);
        }
    }

    @Override
    public synchronized void addProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.progressListenerChain.addProgressListener(progressListener);
    }

    @Override
    public synchronized void removeProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.progressListenerChain.removeProgressListener(progressListener);
    }

    @Override
    @Deprecated
    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.progressListenerChain.addProgressListener((com.amazonaws.event.ProgressListener)new LegacyS3ProgressListener(progressListener));
    }

    @Override
    @Deprecated
    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.progressListenerChain.removeProgressListener((com.amazonaws.event.ProgressListener)new LegacyS3ProgressListener(progressListener));
    }

    public synchronized void addStateChangeListener(TransferStateChangeListener transferStateChangeListener) {
        if (transferStateChangeListener != null) {
            this.stateChangeListeners.add(transferStateChangeListener);
        }
    }

    public synchronized void removeStateChangeListener(TransferStateChangeListener transferStateChangeListener) {
        if (transferStateChangeListener != null) {
            this.stateChangeListeners.remove(transferStateChangeListener);
        }
    }

    @Override
    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    public void setMonitor(TransferMonitor transferMonitor) {
        this.monitor = transferMonitor;
    }

    public TransferMonitor getMonitor() {
        return this.monitor;
    }

    protected void fireProgressEvent(int n) {
        ProgressListenerCallbackExecutor.progressChanged((com.amazonaws.event.ProgressListener)this.progressListenerChain, (ProgressEvent)new ProgressEvent(n, 0L));
    }

    protected void rethrowExecutionException(ExecutionException executionException) {
        throw this.unwrapExecutionException(executionException);
    }

    protected AmazonClientException unwrapExecutionException(ExecutionException executionException) {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof AmazonClientException) {
            return (AmazonClientException)throwable;
        }
        return new AmazonClientException("Unable to complete transfer: " + throwable.getMessage(), throwable);
    }
}

