/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferManager;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferManagerConfiguration;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.CopyImpl;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.CopyPartCallable;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.CopyPartRequestFactory;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferManagerUtils;
import com.amazonaws.mobileconnectors.s3.transfermanager.model.CopyResult;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CopyCallable
implements Callable<CopyResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private String multipartUploadId;
    private final ObjectMetadata metadata;
    private final CopyImpl copy;
    private static final Log log = LogFactory.getLog(CopyCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;

    public CopyCallable(TransferManager transferManager, ExecutorService executorService, CopyImpl copyImpl, CopyObjectRequest copyObjectRequest, ObjectMetadata objectMetadata, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.copyObjectRequest = copyObjectRequest;
        this.metadata = objectMetadata;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListenerChain);
        this.copy = copyImpl;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartCopy() {
        return this.metadata.getContentLength() > this.configuration.getMultipartCopyThreshold();
    }

    @Override
    public CopyResult call() throws Exception {
        this.copy.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartCopy()) {
            this.fireProgressEvent(2);
            this.copyInParts();
            return null;
        }
        return this.copyInOneChunk();
    }

    private CopyResult copyInOneChunk() {
        CopyObjectResult copyObjectResult = this.s3.copyObject(this.copyObjectRequest);
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(this.copyObjectRequest.getDestinationBucketName());
        copyResult.setDestinationKey(this.copyObjectRequest.getDestinationKey());
        copyResult.setETag(copyObjectResult.getETag());
        copyResult.setVersionId(copyObjectResult.getVersionId());
        return copyResult;
    }

    private void copyInParts() throws Exception {
        String string = this.copyObjectRequest.getDestinationBucketName();
        String string2 = this.copyObjectRequest.getDestinationKey();
        this.multipartUploadId = this.initiateMultipartUpload(this.copyObjectRequest);
        long l = this.getOptimalPartSize(this.metadata.getContentLength());
        try {
            CopyPartRequestFactory copyPartRequestFactory = new CopyPartRequestFactory(this.copyObjectRequest, this.multipartUploadId, l, this.metadata.getContentLength());
            this.copyPartsInParallel(copyPartRequestFactory);
        }
        catch (Exception exception) {
            this.fireProgressEvent(8);
            try {
                this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(string, string2, this.multipartUploadId));
            }
            catch (Exception exception2) {
                log.info((Object)("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception2.getMessage()), (Throwable)exception2);
            }
            throw exception;
        }
    }

    private long getOptimalPartSize(long l) {
        long l2 = TransferManagerUtils.calculateOptimalPartSizeForCopy(this.copyObjectRequest, this.configuration, l);
        log.debug((Object)("Calculated optimal part size: " + l2));
        return l2;
    }

    private void copyPartsInParallel(CopyPartRequestFactory copyPartRequestFactory) {
        while (copyPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            CopyPartRequest copyPartRequest = copyPartRequestFactory.getNextCopyPartRequest();
            this.futures.add(this.threadPool.submit(new CopyPartCallable(this.s3, copyPartRequest)));
        }
    }

    private String initiateMultipartUpload(CopyObjectRequest copyObjectRequest) {
        ObjectMetadata objectMetadata;
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey()).withCannedACL(copyObjectRequest.getCannedAccessControlList());
        if (copyObjectRequest.getAccessControlList() != null) {
            initiateMultipartUploadRequest.setAccessControlList(copyObjectRequest.getAccessControlList());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            initiateMultipartUploadRequest.setStorageClass(StorageClass.fromValue(copyObjectRequest.getStorageClass()));
        }
        if (copyObjectRequest.getDestinationSSECustomerKey() != null) {
            initiateMultipartUploadRequest.setSSECustomerKey(copyObjectRequest.getDestinationSSECustomerKey());
        }
        if ((objectMetadata = copyObjectRequest.getNewObjectMetadata()) == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentType() == null) {
            objectMetadata.setContentType(this.metadata.getContentType());
        }
        initiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        this.populateMetadataWithEncryptionParams(this.metadata, objectMetadata);
        String string = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug((Object)("Initiated new multipart upload: " + string));
        return string;
    }

    private void fireProgressEvent(int n) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(0L);
        progressEvent.setEventCode(n);
        this.progressListenerChainCallbackExecutor.progressChanged(progressEvent);
    }

    private void populateMetadataWithEncryptionParams(ObjectMetadata objectMetadata, ObjectMetadata objectMetadata2) {
        Map<String, String> map = objectMetadata.getUserMetadata();
        Map<String, String> map2 = objectMetadata2.getUserMetadata();
        String[] stringArray = new String[]{"x-amz-cek-alg", "x-amz-iv", "x-amz-key", "x-amz-key-v2", "x-amz-wrap-alg", "x-amz-tag-len", "x-amz-matdesc", "x-amz-unencrypted-content-length", "x-amz-unencrypted-content-md5"};
        if (map != null) {
            if (map2 == null) {
                map2 = new HashMap<String, String>();
                objectMetadata2.setUserMetadata(map2);
            }
            for (String string : stringArray) {
                String string2 = map.get(string);
                if (string2 == null) continue;
                map2.put(string, string2);
            }
        }
    }
}

