/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferManagerUtils;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.InputStream;

public class UploadPartRequestFactory {
    private final String bucketName;
    private final String key;
    private final String uploadId;
    private final long optimalPartSize;
    private final File file;
    private final PutObjectRequest putObjectRequest;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;
    private SSECustomerKey sseCustomerKey;

    public UploadPartRequestFactory(PutObjectRequest putObjectRequest, String string, long l) {
        this.putObjectRequest = putObjectRequest;
        this.uploadId = string;
        this.optimalPartSize = l;
        this.bucketName = putObjectRequest.getBucketName();
        this.key = putObjectRequest.getKey();
        this.file = TransferManagerUtils.getRequestFile(putObjectRequest);
        this.remainingBytes = TransferManagerUtils.getContentLength(putObjectRequest);
        this.sseCustomerKey = putObjectRequest.getSSECustomerKey();
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized UploadPartRequest getNextUploadPartRequest() {
        long l = Math.min(this.optimalPartSize, this.remainingBytes);
        boolean bl = this.remainingBytes - l <= 0L;
        UploadPartRequest uploadPartRequest = null;
        uploadPartRequest = this.putObjectRequest.getInputStream() != null ? new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream((InputStream)((Object)new InputSubstream(this.putObjectRequest.getInputStream(), 0L, l, bl))).withPartNumber(this.partNumber++).withPartSize(l) : new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withFile(this.file).withFileOffset(this.offset).withPartNumber(this.partNumber++).withPartSize(l);
        if (this.sseCustomerKey != null) {
            uploadPartRequest.setSSECustomerKey(this.sseCustomerKey);
        }
        this.offset += l;
        this.remainingBytes -= l;
        uploadPartRequest.setLastPart(bl);
        uploadPartRequest.setGeneralProgressListener(this.putObjectRequest.getGeneralProgressListener());
        return uploadPartRequest;
    }
}

