/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.ProgressListener;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public class ProgressReportingInputStream
extends SdkFilterInputStream {
    private static final int NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListener listener;
    private int unnotifiedByteCount;
    private boolean fireCompletedEvent;

    public ProgressReportingInputStream(InputStream inputStream, ProgressListener progressListener) {
        super(inputStream);
        this.listener = progressListener;
    }

    public void setFireCompletedEvent(boolean bl) {
        this.fireCompletedEvent = bl;
    }

    public boolean getFireCompletedEvent() {
        return this.fireCompletedEvent;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.notifyCompleted();
        }
        if (n != -1) {
            this.notify(1);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.notifyCompleted();
        }
        if (n3 != -1) {
            this.notify(n3);
        }
        return n3;
    }

    public void close() throws IOException {
        if (this.unnotifiedByteCount > 0) {
            this.listener.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
        super.close();
    }

    private void notifyCompleted() {
        if (!this.fireCompletedEvent) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(this.unnotifiedByteCount);
        progressEvent.setEventCode(4);
        this.unnotifiedByteCount = 0;
        this.listener.progressChanged(progressEvent);
    }

    private void notify(int n) {
        this.unnotifiedByteCount += n;
        if (this.unnotifiedByteCount >= 8192) {
            this.listener.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
    }
}

