/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);

    public AmazonServiceException handle(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getContent();
        if (inputStream == null || httpResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            String string = (String)httpResponse.getHeaders().get("x-amz-request-id");
            String string2 = (String)httpResponse.getHeaders().get("x-amz-id-2");
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(httpResponse.getStatusText());
            int n = httpResponse.getStatusCode();
            amazonS3Exception.setStatusCode(n);
            amazonS3Exception.setRequestId(string);
            amazonS3Exception.setExtendedRequestId(string2);
            amazonS3Exception.setErrorType(this.errorTypeOf(n));
            return amazonS3Exception;
        }
        String string = "";
        try {
            string = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed in reading the error response", (Throwable)iOException);
            }
            return this.newAmazonS3Exception(httpResponse.getStatusText(), httpResponse);
        }
        try {
            Document document = XpathUtils.documentFrom((String)string);
            String string3 = XpathUtils.asString((String)"Error/Message", (Node)document);
            String string4 = XpathUtils.asString((String)"Error/Code", (Node)document);
            String string5 = XpathUtils.asString((String)"Error/RequestId", (Node)document);
            String string6 = XpathUtils.asString((String)"Error/HostId", (Node)document);
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string3);
            int n = httpResponse.getStatusCode();
            amazonS3Exception.setStatusCode(n);
            amazonS3Exception.setErrorType(this.errorTypeOf(n));
            amazonS3Exception.setErrorCode(string4);
            amazonS3Exception.setRequestId(string5);
            amazonS3Exception.setExtendedRequestId(string6);
            return amazonS3Exception;
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed in parsing the response as XML: " + string), (Throwable)exception);
            }
            return this.newAmazonS3Exception(string, httpResponse);
        }
    }

    private AmazonS3Exception newAmazonS3Exception(String string, HttpResponse httpResponse) {
        AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string);
        int n = httpResponse.getStatusCode();
        amazonS3Exception.setErrorCode(n + " " + httpResponse.getStatusText());
        amazonS3Exception.setStatusCode(n);
        amazonS3Exception.setErrorType(this.errorTypeOf(n));
        return amazonS3Exception;
    }

    private AmazonServiceException.ErrorType errorTypeOf(int n) {
        return n >= 500 ? AmazonServiceException.ErrorType.Service : AmazonServiceException.ErrorType.Client;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

