/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.internal.RestUtils;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.util.HttpUtils;
import java.util.Date;

public class S3Signer
extends AbstractAWSSigner {
    private static final Log log = LogFactory.getLog(S3Signer.class);
    private final String httpVerb;
    private final String resourcePath;

    public S3Signer() {
        this.httpVerb = null;
        this.resourcePath = null;
    }

    public S3Signer(String string, String string2) {
        this.httpVerb = string;
        this.resourcePath = string2;
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    public void sign(Request<?> request, AWSCredentials aWSCredentials) {
        if (this.resourcePath == null) {
            throw new UnsupportedOperationException("Cannot sign a request using a dummy S3Signer instance with no resource path");
        }
        if (aWSCredentials == null || aWSCredentials.getAWSSecretKey() == null) {
            log.debug((Object)"Canonical string will not be signed, as no AWS Secret Key was provided");
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = HttpUtils.appendUri((String)request.getEndpoint().getPath(), (String)this.resourcePath, (boolean)true);
        int n = this.getTimeOffset(request);
        Date date = this.getSignatureDate(n);
        request.addHeader("Date", ServiceUtils.formatRfc822Date(date));
        String string2 = RestUtils.makeS3CanonicalString(this.httpVerb, string, request, null);
        log.debug((Object)("Calculated string to sign:\n\"" + string2 + "\""));
        String string3 = super.signAndBase64Encode(string2, aWSCredentials2.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        request.addHeader("Authorization", "AWS " + aWSCredentials2.getAWSAccessKeyId() + ":" + string3);
    }

    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials aWSSessionCredentials) {
        request.addHeader("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

