/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

public class ServiceUtils {
    private static final Log log = LogFactory.getLog(ServiceUtils.class);
    public static final boolean APPEND_MODE = true;
    public static final boolean OVERWRITE_MODE = false;
    @Deprecated
    protected static final DateUtils dateUtils = new DateUtils();

    public static Date parseIso8601Date(String string) {
        return DateUtils.parseISO8601Date((String)string);
    }

    public static String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date((Date)date);
    }

    public static Date parseRfc822Date(String string) {
        return DateUtils.parseRFC822Date((String)string);
    }

    public static String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date((Date)date);
    }

    public static boolean isMultipartUploadETag(String string) {
        return string.contains("-");
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes(StringUtils.UTF8);
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static URL convertRequestToUrl(Request<?> request) {
        return ServiceUtils.convertRequestToUrl(request, false);
    }

    public static URL convertRequestToUrl(Request<?> request, boolean bl) {
        String string = HttpUtils.urlEncode((String)request.getResourcePath(), (boolean)true);
        if (bl && string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = "/" + string;
        string2 = string2.replaceAll("(?<=/)/", "%2F");
        String string3 = request.getEndpoint() + string2;
        boolean bl2 = true;
        for (String string4 : request.getParameters().keySet()) {
            if (bl2) {
                string3 = string3 + "?";
                bl2 = false;
            } else {
                string3 = string3 + "&";
            }
            String string5 = (String)request.getParameters().get(string4);
            string3 = string3 + string4 + "=" + HttpUtils.urlEncode((String)string5, (boolean)false);
        }
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AmazonClientException("Unable to convert request to well formed URL: " + malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
    }

    public static String join(List<String> list) {
        String string = "";
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + string2;
            bl = false;
        }
        return string;
    }

    public static void downloadObjectToFile(S3Object s3Object, File file, boolean bl, boolean bl2) {
        byte[] byArray;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        OutputStream outputStream = null;
        try {
            int n;
            outputStream = new BufferedOutputStream(new FileOutputStream(file, bl2));
            byArray = new byte[10240];
            while ((n = s3Object.getObjectContent().read(byArray)) > -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            s3Object.getObjectContent().abort();
            throw new AmazonClientException("Unable to store object contents to disk: " + iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception exception) {}
        }
        byArray = null;
        byte[] byArray2 = null;
        try {
            if (!ServiceUtils.isMultipartUploadETag(s3Object.getObjectMetadata().getETag())) {
                byArray = Md5Utils.computeMD5Hash((InputStream)new FileInputStream(file));
                byArray2 = BinaryUtils.fromHex((String)s3Object.getObjectMetadata().getETag());
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to calculate MD5 hash to validate download: " + exception.getMessage()), (Throwable)exception);
        }
        if (bl && byArray != null && byArray2 != null && !Arrays.equals(byArray, byArray2)) {
            throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data stored in '" + file.getAbsolutePath() + "' may be corrupt.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S3Object retryableDownloadS3ObjectToFile(File file, RetryableS3DownloadTask retryableS3DownloadTask, boolean bl) {
        S3Object s3Object;
        boolean bl2;
        boolean bl3 = false;
        do {
            bl2 = false;
            s3Object = retryableS3DownloadTask.getS3ObjectStream();
            if (s3Object == null) {
                return null;
            }
            try {
                ServiceUtils.downloadObjectToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), bl);
            }
            catch (AmazonClientException amazonClientException) {
                if (!amazonClientException.isRetryable()) {
                    throw amazonClientException;
                }
                if (amazonClientException.getCause() instanceof SocketException || amazonClientException.getCause() instanceof SSLProtocolException) {
                    throw amazonClientException;
                }
                bl2 = true;
                if (bl3) {
                    throw amazonClientException;
                }
                log.info((Object)("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")"), (Throwable)amazonClientException);
                bl3 = true;
            }
            finally {
                s3Object.getObjectContent().abort();
            }
        } while (bl2);
        return s3Object;
    }

    public static interface RetryableS3DownloadTask {
        public S3Object getS3ObjectStream();

        public boolean needIntegrityCheck();
    }
}

