/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public final class CipherLiteInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    private final CipherLite cipherLite;
    private final boolean multipart;
    private boolean eof = false;
    private byte[] bufin;
    private byte[] bufout;
    private int curr_pos = 0;
    private int max_pos = 0;

    public CipherLiteInputStream(InputStream inputStream, CipherLite cipherLite) {
        this(inputStream, cipherLite, 512, false);
    }

    public CipherLiteInputStream(InputStream inputStream, CipherLite cipherLite, int n) {
        this(inputStream, cipherLite, n, false);
    }

    public CipherLiteInputStream(InputStream inputStream, CipherLite cipherLite, int n, boolean bl) {
        super(inputStream);
        this.multipart = bl;
        this.cipherLite = cipherLite;
        if (n <= 0 || n % 512 != 0) {
            throw new IllegalArgumentException("buffsize (" + n + ") must be a positive multiple of " + 512);
        }
        this.bufin = new byte[n];
    }

    protected CipherLiteInputStream(InputStream inputStream) {
        this(inputStream, CipherLite.Null, 512, false);
    }

    public int read() throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int n;
            if (this.eof) {
                return -1;
            }
            int n2 = 0;
            do {
                if (n2 > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                n = this.nextChunk();
                ++n2;
            } while (n == 0);
            if (n == -1) {
                return -1;
            }
        }
        return this.bufout[this.curr_pos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.curr_pos >= this.max_pos) {
            int n4;
            if (this.eof) {
                return -1;
            }
            n3 = 0;
            do {
                if (n3 > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                n4 = this.nextChunk();
                ++n3;
            } while (n4 == 0);
            if (n4 == -1) {
                return -1;
            }
        }
        if (n2 <= 0) {
            return 0;
        }
        n3 = this.max_pos - this.curr_pos;
        if (n2 < n3) {
            n3 = n2;
        }
        System.arraycopy(this.bufout, this.curr_pos, byArray, n, n3);
        this.curr_pos += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        this.abortIfNeeded();
        int n = this.max_pos - this.curr_pos;
        if (l > (long)n) {
            l = n;
        }
        if (l < 0L) {
            return 0L;
        }
        this.curr_pos = (int)((long)this.curr_pos + l);
        return l;
    }

    public int available() {
        this.abortIfNeeded();
        return this.max_pos - this.curr_pos;
    }

    public void close() throws IOException {
        this.in.close();
        if (!this.multipart && !S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) {
            try {
                this.cipherLite.doFinal();
            }
            catch (BadPaddingException badPaddingException) {
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                // empty catch block
            }
        }
        this.max_pos = 0;
        this.curr_pos = 0;
        this.abortIfNeeded();
    }

    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported() && this.cipherLite.markSupported();
    }

    public void mark(int n) {
        this.abortIfNeeded();
        this.in.mark(n);
        this.cipherLite.mark();
    }

    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.cipherLite.reset();
        if (this.markSupported()) {
            this.max_pos = 0;
            this.curr_pos = 0;
            this.eof = false;
        }
    }

    private int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        int n = this.in.read(this.bufin);
        if (n == -1) {
            block8: {
                this.eof = true;
                try {
                    this.bufout = this.cipherLite.doFinal();
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                }
                catch (BadPaddingException badPaddingException) {
                    if (!S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) break block8;
                    throw new SecurityException(badPaddingException);
                }
            }
            if (this.bufout == null) {
                return -1;
            }
            this.curr_pos = 0;
            this.max_pos = this.bufout.length;
            return this.max_pos;
        }
        try {
            this.bufout = this.cipherLite.update(this.bufin, 0, n);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.curr_pos = 0;
        this.max_pos = this.bufout == null ? 0 : this.bufout.length;
        return this.max_pos;
    }
}

