/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleAE;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleAEStrict;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleEO;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;

public class CryptoModuleDispatcher
extends S3CryptoModule<MultipartUploadContext> {
    private final CryptoMode defaultCryptoMode;
    private final S3CryptoModuleEO eo;
    private final S3CryptoModuleAE ae;

    public CryptoModuleDispatcher(S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        CryptoMode cryptoMode = cryptoConfiguration.getCryptoMode();
        this.defaultCryptoMode = cryptoMode == null ? CryptoMode.EncryptionOnly : cryptoMode;
        switch (this.defaultCryptoMode) {
            case StrictAuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAEStrict(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration);
                this.eo = null;
                break;
            }
            case AuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAE(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration);
                this.eo = null;
                break;
            }
            default: {
                this.eo = new S3CryptoModuleEO(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration);
                this.ae = new S3CryptoModuleAE(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration);
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.putObjectSecurely(putObjectRequest) : this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        return this.ae.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) throws AmazonClientException, AmazonServiceException {
        return this.ae.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.completeMultipartUploadSecurely(completeMultipartUploadRequest) : this.ae.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (this.defaultCryptoMode == CryptoMode.EncryptionOnly) {
            this.eo.abortMultipartUploadSecurely(abortMultipartUploadRequest);
        } else {
            this.ae.abortMultipartUploadSecurely(abortMultipartUploadRequest);
        }
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.initiateMultipartUploadSecurely(initiateMultipartUploadRequest) : this.ae.initiateMultipartUploadSecurely(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.uploadPartSecurely(uploadPartRequest) : this.ae.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.copyPartSecurely(copyPartRequest) : this.ae.copyPartSecurely(copyPartRequest);
    }
}

