/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ObjectRestoreResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata
implements ServerSideEncryptionResult,
ObjectExpirationResult,
ObjectRestoreResult,
Cloneable {
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = "AES256";
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> map) {
        this.userMetadata = map;
    }

    public void setHeader(String string, Object object) {
        this.metadata.put(string, object);
    }

    public void addUserMetadata(String string, String string2) {
        this.userMetadata.put(string, string2);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
    }

    public Object getRawMetadataValue(String string) {
        return this.metadata.get(string);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date date) {
        this.metadata.put("Last-Modified", date);
    }

    public long getContentLength() {
        Long l = (Long)this.metadata.get("Content-Length");
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public long getInstanceLength() {
        int n;
        String string = (String)this.metadata.get("Content-Range");
        if (string != null && (n = string.lastIndexOf("/")) >= 0) {
            return Long.parseLong(string.substring(n + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long l) {
        this.metadata.put("Content-Length", l);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String string) {
        this.metadata.put("Content-Type", string);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String string) {
        this.metadata.put("Content-Encoding", string);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String string) {
        this.metadata.put("Cache-Control", string);
    }

    public void setContentMD5(String string) {
        if (string == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", string);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String string) {
        this.metadata.put("Content-Disposition", string);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-amz-version-id");
    }

    @Override
    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Deprecated
    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Override
    public void setSSEAlgorithm(String string) {
        this.metadata.put("x-amz-server-side-encryption", string);
    }

    @Deprecated
    public void setServerSideEncryption(String string) {
        this.metadata.put("x-amz-server-side-encryption", string);
    }

    @Override
    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-algorithm");
    }

    @Override
    public void setSSECustomerAlgorithm(String string) {
        this.metadata.put("x-amz-server-side-encryption-customer-algorithm", string);
    }

    @Override
    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-key-MD5");
    }

    @Override
    public void setSSECustomerKeyMd5(String string) {
        this.metadata.put("x-amz-server-side-encryption-customer-key-MD5", string);
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(Date date) {
        this.expirationTime = date;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String string) {
        this.expirationTimeRuleId = string;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    @Override
    public void setRestoreExpirationTime(Date date) {
        this.restoreExpirationTime = date;
    }

    @Override
    public void setOngoingRestore(boolean bl) {
        this.ongoingRestore = bl;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public void setHttpExpiresDate(Date date) {
        this.httpExpiresDate = date;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public String getUserMetaDataOf(String string) {
        return this.userMetadata == null ? null : this.userMetadata.get(string);
    }

    public ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
    }

    private ObjectMetadata(ObjectMetadata objectMetadata) {
        this.userMetadata = objectMetadata.userMetadata == null ? null : new HashMap<String, String>(objectMetadata.userMetadata);
        this.metadata = objectMetadata.metadata == null ? null : new HashMap<String, Object>(objectMetadata.metadata);
        this.expirationTime = objectMetadata.expirationTime;
        this.expirationTimeRuleId = objectMetadata.expirationTimeRuleId;
        this.httpExpiresDate = objectMetadata.httpExpiresDate;
        this.ongoingRestore = objectMetadata.ongoingRestore;
        this.restoreExpirationTime = objectMetadata.restoreExpirationTime;
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }
}

