/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.TagSet;
import java.util.List;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketVersioningConfiguration bucketVersioningConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("VersioningConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xmlWriter.start("Status").value(bucketVersioningConfiguration.getStatus()).end();
        Boolean bl = bucketVersioningConfiguration.isMfaDeleteEnabled();
        if (bl != null) {
            if (bl.booleanValue()) {
                xmlWriter.start("MfaDelete").value("Enabled").end();
            } else {
                xmlWriter.start("MfaDelete").value("Disabled").end();
            }
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration bucketLoggingConfiguration) {
        String string = bucketLoggingConfiguration.getLogFilePrefix();
        if (string == null) {
            string = "";
        }
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("BucketLoggingStatus", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (bucketLoggingConfiguration.isLoggingEnabled()) {
            xmlWriter.start("LoggingEnabled");
            xmlWriter.start("TargetBucket").value(bucketLoggingConfiguration.getDestinationBucketName()).end();
            xmlWriter.start("TargetPrefix").value(bucketLoggingConfiguration.getLogFilePrefix()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketNotificationConfiguration bucketNotificationConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("NotificationConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        List<BucketNotificationConfiguration.TopicConfiguration> list = bucketNotificationConfiguration.getTopicConfigurations();
        for (BucketNotificationConfiguration.TopicConfiguration topicConfiguration : list) {
            xmlWriter.start("TopicConfiguration");
            xmlWriter.start("Topic").value(topicConfiguration.getTopic()).end();
            xmlWriter.start("Event").value(topicConfiguration.getEvent()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        XmlWriter xmlWriter;
        Object object;
        XmlWriter xmlWriter2 = new XmlWriter();
        xmlWriter2.start("WebsiteConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (bucketWebsiteConfiguration.getIndexDocumentSuffix() != null) {
            object = xmlWriter2.start("IndexDocument");
            ((XmlWriter)object).start("Suffix").value(bucketWebsiteConfiguration.getIndexDocumentSuffix()).end();
            ((XmlWriter)object).end();
        }
        if (bucketWebsiteConfiguration.getErrorDocument() != null) {
            object = xmlWriter2.start("ErrorDocument");
            ((XmlWriter)object).start("Key").value(bucketWebsiteConfiguration.getErrorDocument()).end();
            ((XmlWriter)object).end();
        }
        if ((object = bucketWebsiteConfiguration.getRedirectAllRequestsTo()) != null) {
            xmlWriter = xmlWriter2.start("RedirectAllRequestsTo");
            if (((RedirectRule)object).getprotocol() != null) {
                xmlWriter2.start("Protocol").value(((RedirectRule)object).getprotocol()).end();
            }
            if (((RedirectRule)object).getHostName() != null) {
                xmlWriter2.start("HostName").value(((RedirectRule)object).getHostName()).end();
            }
            if (((RedirectRule)object).getReplaceKeyPrefixWith() != null) {
                xmlWriter2.start("ReplaceKeyPrefixWith").value(((RedirectRule)object).getReplaceKeyPrefixWith()).end();
            }
            if (((RedirectRule)object).getReplaceKeyWith() != null) {
                xmlWriter2.start("ReplaceKeyWith").value(((RedirectRule)object).getReplaceKeyWith()).end();
            }
            xmlWriter.end();
        }
        if (bucketWebsiteConfiguration.getRoutingRules() != null && bucketWebsiteConfiguration.getRoutingRules().size() > 0) {
            xmlWriter = xmlWriter2.start("RoutingRules");
            for (RoutingRule routingRule : bucketWebsiteConfiguration.getRoutingRules()) {
                this.writeRule(xmlWriter, routingRule);
            }
            xmlWriter.end();
        }
        xmlWriter2.end();
        return xmlWriter2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration bucketLifecycleConfiguration) throws AmazonClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : bucketLifecycleConfiguration.getRules()) {
            this.writeRule(xmlWriter, rule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws AmazonClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("CORSConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (CORSRule cORSRule : bucketCrossOriginConfiguration.getRules()) {
            this.writeRule(xmlWriter, cORSRule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeRule(XmlWriter xmlWriter, BucketLifecycleConfiguration.Rule rule) {
        BucketLifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition;
        xmlWriter.start("Rule");
        if (rule.getId() != null) {
            xmlWriter.start("ID").value(rule.getId()).end();
        }
        xmlWriter.start("Prefix").value(rule.getPrefix()).end();
        xmlWriter.start("Status").value(rule.getStatus()).end();
        BucketLifecycleConfiguration.Transition transition = rule.getTransition();
        if (transition != null) {
            xmlWriter.start("Transition");
            if (transition.getDate() != null) {
                xmlWriter.start("Date");
                xmlWriter.value(ServiceUtils.formatIso8601Date(transition.getDate()));
                xmlWriter.end();
            }
            if (transition.getDays() != -1) {
                xmlWriter.start("Days");
                xmlWriter.value(Integer.toString(transition.getDays()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(transition.getStorageClass().toString());
            xmlWriter.end();
            xmlWriter.end();
        }
        if ((noncurrentVersionTransition = rule.getNoncurrentVersionTransition()) != null) {
            xmlWriter.start("NoncurrentVersionTransition");
            if (noncurrentVersionTransition.getDays() != -1) {
                xmlWriter.start("NoncurrentDays");
                xmlWriter.value(Integer.toString(noncurrentVersionTransition.getDays()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(noncurrentVersionTransition.getStorageClass().toString());
            xmlWriter.end();
            xmlWriter.end();
        }
        if (rule.getExpirationInDays() != -1) {
            xmlWriter.start("Expiration");
            xmlWriter.start("Days").value("" + rule.getExpirationInDays()).end();
            xmlWriter.end();
        }
        if (rule.getNoncurrentVersionExpirationInDays() != -1) {
            xmlWriter.start("NoncurrentVersionExpiration");
            xmlWriter.start("NoncurrentDays").value(Integer.toString(rule.getNoncurrentVersionExpirationInDays())).end();
            xmlWriter.end();
        }
        if (rule.getExpirationDate() != null) {
            xmlWriter.start("Expiration");
            xmlWriter.start("Date").value(ServiceUtils.formatIso8601Date(rule.getExpirationDate())).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, CORSRule cORSRule) {
        xmlWriter.start("CORSRule");
        if (cORSRule.getId() != null) {
            xmlWriter.start("ID").value(cORSRule.getId()).end();
        }
        if (cORSRule.getAllowedOrigins() != null) {
            for (String object : cORSRule.getAllowedOrigins()) {
                xmlWriter.start("AllowedOrigin").value(object).end();
            }
        }
        if (cORSRule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods allowedMethods : cORSRule.getAllowedMethods()) {
                xmlWriter.start("AllowedMethod").value(allowedMethods.toString()).end();
            }
        }
        if (cORSRule.getMaxAgeSeconds() != 0) {
            xmlWriter.start("MaxAgeSeconds").value(Integer.toString(cORSRule.getMaxAgeSeconds())).end();
        }
        if (cORSRule.getExposedHeaders() != null) {
            for (String string : cORSRule.getExposedHeaders()) {
                xmlWriter.start("ExposeHeader").value(string).end();
            }
        }
        if (cORSRule.getAllowedHeaders() != null) {
            for (String string : cORSRule.getAllowedHeaders()) {
                xmlWriter.start("AllowedHeader").value(string).end();
            }
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, RoutingRule routingRule) {
        xmlWriter.start("RoutingRule");
        RoutingRuleCondition routingRuleCondition = routingRule.getCondition();
        if (routingRuleCondition != null) {
            xmlWriter.start("Condition");
            xmlWriter.start("KeyPrefixEquals");
            if (routingRuleCondition.getKeyPrefixEquals() != null) {
                xmlWriter.value(routingRuleCondition.getKeyPrefixEquals());
            }
            xmlWriter.end();
            if (routingRuleCondition.getHttpErrorCodeReturnedEquals() != null) {
                xmlWriter.start("HttpErrorCodeReturnedEquals ").value(routingRuleCondition.getHttpErrorCodeReturnedEquals()).end();
            }
            xmlWriter.end();
        }
        xmlWriter.start("Redirect");
        RedirectRule redirectRule = routingRule.getRedirect();
        if (redirectRule != null) {
            if (redirectRule.getprotocol() != null) {
                xmlWriter.start("Protocol").value(redirectRule.getprotocol()).end();
            }
            if (redirectRule.getHostName() != null) {
                xmlWriter.start("HostName").value(redirectRule.getHostName()).end();
            }
            if (redirectRule.getReplaceKeyPrefixWith() != null) {
                xmlWriter.start("ReplaceKeyPrefixWith").value(redirectRule.getReplaceKeyPrefixWith()).end();
            }
            if (redirectRule.getReplaceKeyWith() != null) {
                xmlWriter.start("ReplaceKeyWith").value(redirectRule.getReplaceKeyWith()).end();
            }
            if (redirectRule.getHttpRedirectCode() != null) {
                xmlWriter.start("HttpRedirectCode").value(redirectRule.getHttpRedirectCode()).end();
            }
        }
        xmlWriter.end();
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration bucketTaggingConfiguration) throws AmazonClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Tagging");
        for (TagSet tagSet : bucketTaggingConfiguration.getAllTagSets()) {
            this.writeRule(xmlWriter, tagSet);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeRule(XmlWriter xmlWriter, TagSet tagSet) {
        xmlWriter.start("TagSet");
        for (String string : tagSet.getAllTags().keySet()) {
            xmlWriter.start("Tag");
            xmlWriter.start("Key").value(string).end();
            xmlWriter.start("Value").value(tagSet.getTag(string)).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }
}

