/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.S3ProgressPublisher;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.UploadPartCallable;
import com.amazonaws.services.s3.transfer.internal.UploadPartRequestFactory;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class UploadCallable
implements Callable<UploadResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private String multipartUploadId;
    private final UploadImpl upload;
    private static final Log log = LogFactory.getLog(UploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listener;
    private final TransferProgress transferProgress;
    private final List<PartETag> eTagsToSkip = new ArrayList<PartETag>();
    private PersistableUpload persistableUpload;

    public UploadCallable(TransferManager transferManager, ExecutorService executorService, UploadImpl uploadImpl, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain, String string, TransferProgress transferProgress) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.putObjectRequest = putObjectRequest;
        this.listener = progressListenerChain;
        this.upload = uploadImpl;
        this.multipartUploadId = string;
        this.transferProgress = transferProgress;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    List<PartETag> getETags() {
        return this.eTagsToSkip;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartUpload() {
        return TransferManagerUtils.shouldUseMultipartUpload(this.putObjectRequest, this.configuration);
    }

    @Override
    public UploadResult call() throws Exception {
        this.upload.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartUpload()) {
            this.fireProgressEvent(2);
            return this.uploadInParts();
        }
        return this.uploadInOneChunk();
    }

    private UploadResult uploadInOneChunk() {
        PutObjectResult putObjectResult = this.s3.putObject(this.putObjectRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.putObjectRequest.getBucketName());
        uploadResult.setKey(this.putObjectRequest.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        return uploadResult;
    }

    private void captureUploadStateIfPossible() {
        if (this.putObjectRequest.getSSECustomerKey() == null) {
            this.persistableUpload = new PersistableUpload(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.putObjectRequest.getFile().getAbsolutePath(), this.multipartUploadId, this.configuration.getMinimumUploadPartSize(), this.configuration.getMultipartUploadThreshold());
            this.notifyPersistableTransferAvailability();
        }
    }

    public PersistableUpload getPersistableUpload() {
        return this.persistableUpload;
    }

    private void notifyPersistableTransferAvailability() {
        S3ProgressPublisher.publishTransferPersistable((ProgressListener)this.listener, this.persistableUpload);
    }

    private UploadResult uploadInParts() throws Exception {
        boolean bl = this.s3 instanceof AmazonS3EncryptionClient;
        long l = this.getOptimalPartSize(bl);
        if (this.multipartUploadId == null) {
            this.multipartUploadId = this.initiateMultipartUpload(this.putObjectRequest, bl);
        }
        try {
            UploadPartRequestFactory uploadPartRequestFactory = new UploadPartRequestFactory(this.putObjectRequest, this.multipartUploadId, l);
            if (TransferManagerUtils.isUploadParallelizable(this.putObjectRequest, bl)) {
                this.captureUploadStateIfPossible();
                this.uploadPartsInParallel(uploadPartRequestFactory, this.multipartUploadId);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(uploadPartRequestFactory);
            return uploadResult;
        }
        catch (Exception exception) {
            this.fireProgressEvent(8);
            this.performAbortMultipartUpload();
            throw exception;
        }
        finally {
            if (this.putObjectRequest.getInputStream() != null) {
                try {
                    this.putObjectRequest.getInputStream().close();
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to cleanly close input stream: " + exception.getMessage()), (Throwable)exception);
                }
            }
        }
    }

    void performAbortMultipartUpload() {
        try {
            if (this.multipartUploadId != null) {
                this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.multipartUploadId));
            }
        }
        catch (Exception exception) {
            log.info((Object)("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception.getMessage()), (Throwable)exception);
        }
    }

    private long getOptimalPartSize(boolean bl) {
        long l = TransferManagerUtils.calculateOptimalPartSize(this.putObjectRequest, this.configuration);
        if (bl && l % 32L > 0L) {
            l = l - l % 32L + 32L;
        }
        log.debug((Object)("Calculated optimal part size: " + l));
        return l;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory uploadPartRequestFactory) {
        Object object;
        Object object2;
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        while (uploadPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            object2 = uploadPartRequestFactory.getNextUploadPartRequest();
            object = object2.getInputStream();
            if (object != null && ((InputStream)object).markSupported()) {
                if (object2.getPartSize() >= Integer.MAX_VALUE) {
                    ((InputStream)object).mark(Integer.MAX_VALUE);
                } else {
                    ((InputStream)object).mark((int)object2.getPartSize());
                }
            }
            arrayList.add(this.s3.uploadPart((UploadPartRequest)((Object)object2)).getPartETag());
        }
        object2 = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.multipartUploadId, arrayList));
        object = new UploadResult();
        ((UploadResult)object).setBucketName(((CompleteMultipartUploadResult)object2).getBucketName());
        ((UploadResult)object).setKey(((CompleteMultipartUploadResult)object2).getKey());
        ((UploadResult)object).setETag(((CompleteMultipartUploadResult)object2).getETag());
        ((UploadResult)object).setVersionId(((CompleteMultipartUploadResult)object2).getVersionId());
        return object;
    }

    private void uploadPartsInParallel(UploadPartRequestFactory uploadPartRequestFactory, String string) {
        Map<Integer, PartSummary> map = this.identifyExistingPartsForResume(string);
        while (uploadPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest uploadPartRequest = uploadPartRequestFactory.getNextUploadPartRequest();
            if (map.containsKey(uploadPartRequest.getPartNumber())) {
                PartSummary partSummary = map.get(uploadPartRequest.getPartNumber());
                this.eTagsToSkip.add(new PartETag(uploadPartRequest.getPartNumber(), partSummary.getETag()));
                this.transferProgress.updateProgress(partSummary.getSize());
                continue;
            }
            this.futures.add(this.threadPool.submit(new UploadPartCallable(this.s3, uploadPartRequest)));
        }
    }

    private Map<Integer, PartSummary> identifyExistingPartsForResume(String string) {
        HashMap<Integer, PartSummary> hashMap = new HashMap<Integer, PartSummary>();
        if (string == null) {
            return hashMap;
        }
        int n = 0;
        while (true) {
            PartListing partListing = this.s3.listParts(new ListPartsRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), string).withPartNumberMarker(n));
            for (PartSummary partSummary : partListing.getParts()) {
                hashMap.put(partSummary.getPartNumber(), partSummary);
            }
            if (!partListing.isTruncated()) {
                return hashMap;
            }
            n = partListing.getNextPartNumberMarker();
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest, boolean bl) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        if (bl && putObjectRequest instanceof EncryptedPutObjectRequest) {
            initiateMultipartUploadRequest = new EncryptedInitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
            ((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).setMaterialsDescription(((EncryptedPutObjectRequest)putObjectRequest).getMaterialsDescription());
        } else {
            initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        }
        TransferManager.appendMultipartUserAgent(initiateMultipartUploadRequest);
        if (putObjectRequest.getStorageClass() != null) {
            initiateMultipartUploadRequest.setStorageClass(StorageClass.fromValue(putObjectRequest.getStorageClass()));
        }
        if (putObjectRequest.getRedirectLocation() != null) {
            initiateMultipartUploadRequest.setRedirectLocation(putObjectRequest.getRedirectLocation());
        }
        if (putObjectRequest.getSSECustomerKey() != null) {
            initiateMultipartUploadRequest.setSSECustomerKey(putObjectRequest.getSSECustomerKey());
        }
        String string = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug((Object)("Initiated new multipart upload: " + string));
        return string;
    }

    private void fireProgressEvent(int n) {
        ProgressEvent progressEvent = new ProgressEvent(0L);
        progressEvent.setEventCode(n);
        ProgressListenerCallbackExecutor.progressChanged((ProgressListener)this.listener, (ProgressEvent)progressEvent);
    }
}

