/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.transform.LambdaConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.QueueConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.TopicConfigurationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class BucketNotificationConfigurationStaxUnmarshaller
implements Unmarshaller<BucketNotificationConfiguration, InputStream> {
    private static BucketNotificationConfigurationStaxUnmarshaller instance = new BucketNotificationConfigurationStaxUnmarshaller();
    private static final XmlPullParserFactory xmlPullParserFactory;

    public static BucketNotificationConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private BucketNotificationConfigurationStaxUnmarshaller() {
    }

    public BucketNotificationConfiguration unmarshall(InputStream inputStream) throws Exception {
        int xmlEvent;
        XmlPullParser xpp = xmlPullParserFactory.newPullParser();
        xpp.setInput(inputStream, null);
        StaxUnmarshallerContext context = new StaxUnmarshallerContext(xpp, null);
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        BucketNotificationConfiguration config = new BucketNotificationConfiguration();
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                Map.Entry<String, NotificationConfiguration> entry;
                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    entry = TopicConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    entry = QueueConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!context.testExpression("CloudFunctionConfiguration", targetDepth)) continue;
                entry = LambdaConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                config.addConfiguration(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            return config;
        }
        return config;
    }

    static {
        try {
            xmlPullParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException xppe) {
            throw new AmazonClientException("Couldn't initialize XmlPullParserFactory", (Throwable)xppe);
        }
    }
}

