/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class S3HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String value, boolean path) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = " ";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (path && "%2F".equals(replacement)) {
                    replacement = "/";
                } else if (path && "%3A".equals(replacement)) {
                    replacement = ":";
                } else if (path && "%27".equals(replacement)) {
                    replacement = "'";
                } else if (path && "%28".equals(replacement)) {
                    replacement = "(";
                } else if (path && "%29".equals(replacement)) {
                    replacement = ")";
                } else if (path && "%21".equals(replacement)) {
                    replacement = "!";
                } else if (path && "%5B".equals(replacement)) {
                    replacement = "[";
                } else if (path && "%5D".equals(replacement)) {
                    replacement = "]";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F")).append("|").append(Pattern.quote("%3A")).append("|").append(Pattern.quote("%27")).append("|").append(Pattern.quote("%28")).append("|").append(Pattern.quote("%29")).append("|").append(Pattern.quote("%21")).append("|").append(Pattern.quote("%5B")).append("|").append(Pattern.quote("%5D")).append("|").append(Pattern.quote("%24"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

